/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.fs.s3presto.shaded.org.apache.hadoop.hdfs.server.datanode;

public class CachingStrategy {
    private final Boolean dropBehind;
    private final Long readahead;

    public static CachingStrategy newDefaultStrategy() {
        return new CachingStrategy(null, null);
    }

    public static CachingStrategy newDropBehind() {
        return new CachingStrategy(true, null);
    }

    public CachingStrategy(Boolean dropBehind, Long readahead) {
        this.dropBehind = dropBehind;
        this.readahead = readahead;
    }

    public Boolean getDropBehind() {
        return this.dropBehind;
    }

    public Long getReadahead() {
        return this.readahead;
    }

    public String toString() {
        return "CachingStrategy(dropBehind=" + this.dropBehind + ", readahead=" + this.readahead + ")";
    }

    public static class Builder {
        private Boolean dropBehind;
        private Long readahead;

        public Builder(CachingStrategy prev) {
            this.dropBehind = prev.dropBehind;
            this.readahead = prev.readahead;
        }

        public Builder setDropBehind(Boolean dropBehind) {
            this.dropBehind = dropBehind;
            return this;
        }

        public Builder setReadahead(Long readahead) {
            this.readahead = readahead;
            return this;
        }

        public CachingStrategy build() {
            return new CachingStrategy(this.dropBehind, this.readahead);
        }
    }
}

