/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.fs.s3presto.shaded.com.facebook.presto.hive.orc;

import java.io.IOException;
import java.util.Objects;
import org.apache.flink.fs.s3presto.shaded.com.facebook.presto.hive.FileFormatDataSourceStats;
import org.apache.flink.fs.s3presto.shaded.com.facebook.presto.hive.HiveErrorCode;
import org.apache.flink.fs.s3presto.shaded.com.facebook.presto.orc.AbstractOrcDataSource;
import org.apache.flink.fs.s3presto.shaded.com.facebook.presto.orc.OrcDataSourceId;
import org.apache.flink.fs.s3presto.shaded.com.facebook.presto.spi.ErrorCodeSupplier;
import org.apache.flink.fs.s3presto.shaded.com.facebook.presto.spi.PrestoException;
import org.apache.flink.fs.s3presto.shaded.io.airlift.units.DataSize;
import org.apache.flink.fs.s3presto.shaded.org.apache.hadoop.fs.FSDataInputStream;

public class HdfsOrcDataSource
extends AbstractOrcDataSource {
    private final FSDataInputStream inputStream;
    private final FileFormatDataSourceStats stats;

    public HdfsOrcDataSource(OrcDataSourceId id, long size, DataSize maxMergeDistance, DataSize maxReadSize, DataSize streamBufferSize, boolean lazyReadSmallRanges, FSDataInputStream inputStream, FileFormatDataSourceStats stats) {
        super(id, size, maxMergeDistance, maxReadSize, streamBufferSize, lazyReadSmallRanges);
        this.inputStream = Objects.requireNonNull(inputStream, "inputStream is null");
        this.stats = Objects.requireNonNull(stats, "stats is null");
    }

    public void close() throws IOException {
        this.inputStream.close();
    }

    protected void readInternal(long position, byte[] buffer, int bufferOffset, int bufferLength) throws IOException {
        try {
            long readStart = System.nanoTime();
            this.inputStream.readFully(position, buffer, bufferOffset, bufferLength);
            this.stats.readDataBytesPerSecond(bufferLength, System.nanoTime() - readStart);
        }
        catch (PrestoException e) {
            throw e;
        }
        catch (Exception e) {
            String message = String.format("Error reading from %s at position %s", new Object[]{this, position});
            if (e.getClass().getSimpleName().equals("BlockMissingException")) {
                throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_MISSING_DATA, message, (Throwable)e);
            }
            throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_UNKNOWN_ERROR, message, (Throwable)e);
        }
    }
}

