/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.fs.s3presto.shaded.com.facebook.presto.hive;

import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.inject.Inject;
import org.apache.flink.fs.s3presto.shaded.com.facebook.presto.hive.HiveBucketProperty;
import org.apache.flink.fs.s3presto.shaded.com.facebook.presto.hive.HiveClientConfig;
import org.apache.flink.fs.s3presto.shaded.com.facebook.presto.hive.HiveStorageFormat;
import org.apache.flink.fs.s3presto.shaded.com.facebook.presto.spi.ErrorCodeSupplier;
import org.apache.flink.fs.s3presto.shaded.com.facebook.presto.spi.PrestoException;
import org.apache.flink.fs.s3presto.shaded.com.facebook.presto.spi.StandardErrorCode;
import org.apache.flink.fs.s3presto.shaded.com.facebook.presto.spi.session.PropertyMetadata;
import org.apache.flink.fs.s3presto.shaded.com.facebook.presto.spi.type.Type;
import org.apache.flink.fs.s3presto.shaded.com.facebook.presto.spi.type.TypeManager;
import org.apache.flink.fs.s3presto.shaded.com.facebook.presto.spi.type.TypeSignature;
import org.apache.flink.fs.s3presto.shaded.com.facebook.presto.spi.type.VarcharType;
import org.apache.flink.fs.s3presto.shaded.com.google.common.collect.ImmutableList;

public class HiveTableProperties {
    public static final String EXTERNAL_LOCATION_PROPERTY = "external_location";
    public static final String STORAGE_FORMAT_PROPERTY = "format";
    public static final String PARTITIONED_BY_PROPERTY = "partitioned_by";
    public static final String BUCKETED_BY_PROPERTY = "bucketed_by";
    public static final String BUCKET_COUNT_PROPERTY = "bucket_count";
    public static final String ORC_BLOOM_FILTER_COLUMNS = "orc_bloom_filter_columns";
    public static final String ORC_BLOOM_FILTER_FPP = "orc_bloom_filter_fpp";
    private final List<PropertyMetadata<?>> tableProperties;

    @Inject
    public HiveTableProperties(TypeManager typeManager, HiveClientConfig config) {
        this.tableProperties = ImmutableList.of(PropertyMetadata.stringSessionProperty((String)EXTERNAL_LOCATION_PROPERTY, (String)"File system location URI for external table", null, (boolean)false), new PropertyMetadata(STORAGE_FORMAT_PROPERTY, "Hive storage format for the table", (Type)VarcharType.createUnboundedVarcharType(), HiveStorageFormat.class, (Object)config.getHiveStorageFormat(), false, value -> HiveStorageFormat.valueOf(((String)value).toUpperCase(Locale.ENGLISH)), Enum::toString), new PropertyMetadata(PARTITIONED_BY_PROPERTY, "Partition columns", typeManager.getType(TypeSignature.parseTypeSignature((String)"array(varchar)")), List.class, ImmutableList.of(), false, value -> ImmutableList.copyOf(((Collection)value).stream().map(name -> ((String)name).toLowerCase(Locale.ENGLISH)).collect(Collectors.toList())), value -> value), new PropertyMetadata(BUCKETED_BY_PROPERTY, "Bucketing columns", typeManager.getType(TypeSignature.parseTypeSignature((String)"array(varchar)")), List.class, ImmutableList.of(), false, value -> ImmutableList.copyOf(((Collection)value).stream().map(name -> ((String)name).toLowerCase(Locale.ENGLISH)).collect(Collectors.toList())), value -> value), new PropertyMetadata(ORC_BLOOM_FILTER_COLUMNS, "ORC Bloom filter index columns", typeManager.getType(TypeSignature.parseTypeSignature((String)"array(varchar)")), List.class, ImmutableList.of(), false, value -> ((Collection)value).stream().map(String.class::cast).map(name -> name.toLowerCase(Locale.ENGLISH)).collect(ImmutableList.toImmutableList()), value -> value), PropertyMetadata.doubleSessionProperty((String)ORC_BLOOM_FILTER_FPP, (String)"ORC Bloom filter false positive probability", (Double)config.getOrcDefaultBloomFilterFpp(), (boolean)false), PropertyMetadata.integerSessionProperty((String)BUCKET_COUNT_PROPERTY, (String)"Number of buckets", (Integer)0, (boolean)false));
    }

    public List<PropertyMetadata<?>> getTableProperties() {
        return this.tableProperties;
    }

    public static String getExternalLocation(Map<String, Object> tableProperties) {
        return (String)tableProperties.get(EXTERNAL_LOCATION_PROPERTY);
    }

    public static HiveStorageFormat getHiveStorageFormat(Map<String, Object> tableProperties) {
        return (HiveStorageFormat)((Object)tableProperties.get(STORAGE_FORMAT_PROPERTY));
    }

    public static List<String> getPartitionedBy(Map<String, Object> tableProperties) {
        return (List)tableProperties.get(PARTITIONED_BY_PROPERTY);
    }

    public static Optional<HiveBucketProperty> getBucketProperty(Map<String, Object> tableProperties) {
        List<String> bucketedBy = HiveTableProperties.getBucketedBy(tableProperties);
        int bucketCount = (Integer)tableProperties.get(BUCKET_COUNT_PROPERTY);
        if (bucketedBy.isEmpty() && bucketCount == 0) {
            return Optional.empty();
        }
        if (bucketCount < 0) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.INVALID_TABLE_PROPERTY, String.format("%s must be greater than zero", BUCKET_COUNT_PROPERTY));
        }
        if (bucketedBy.isEmpty() || bucketCount == 0) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.INVALID_TABLE_PROPERTY, String.format("%s and %s must be specified together", BUCKETED_BY_PROPERTY, BUCKET_COUNT_PROPERTY));
        }
        return Optional.of(new HiveBucketProperty(bucketedBy, bucketCount));
    }

    private static List<String> getBucketedBy(Map<String, Object> tableProperties) {
        return (List)tableProperties.get(BUCKETED_BY_PROPERTY);
    }

    public static List<String> getOrcBloomFilterColumns(Map<String, Object> tableProperties) {
        return (List)tableProperties.get(ORC_BLOOM_FILTER_COLUMNS);
    }

    public static Double getOrcBloomFilterFpp(Map<String, Object> tableProperties) {
        return (Double)tableProperties.get(ORC_BLOOM_FILTER_FPP);
    }
}

