/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.fs.s3presto.shaded.com.amazonaws.util.json;

import java.io.File;
import java.io.IOException;
import java.io.Writer;
import org.apache.flink.fs.s3presto.shaded.com.amazonaws.SdkClientException;
import org.apache.flink.fs.s3presto.shaded.com.fasterxml.jackson.core.JsonFactory;
import org.apache.flink.fs.s3presto.shaded.com.fasterxml.jackson.core.JsonGenerator;
import org.apache.flink.fs.s3presto.shaded.com.fasterxml.jackson.core.JsonParser;
import org.apache.flink.fs.s3presto.shaded.com.fasterxml.jackson.databind.DeserializationFeature;
import org.apache.flink.fs.s3presto.shaded.com.fasterxml.jackson.databind.JsonNode;
import org.apache.flink.fs.s3presto.shaded.com.fasterxml.jackson.databind.ObjectMapper;
import org.apache.flink.fs.s3presto.shaded.com.fasterxml.jackson.databind.ObjectWriter;

public enum Jackson {

    private static final ObjectMapper objectMapper = new ObjectMapper();
    private static final ObjectWriter writer;
    private static final ObjectWriter prettyWriter;

    public static String toJsonPrettyString(Object value) {
        try {
            return prettyWriter.writeValueAsString(value);
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }

    public static String toJsonString(Object value) {
        try {
            return writer.writeValueAsString(value);
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }

    public static <T> T fromJsonString(String json, Class<T> clazz) {
        if (json == null) {
            return null;
        }
        try {
            return objectMapper.readValue(json, clazz);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to parse Json String.", e);
        }
    }

    public static JsonNode jsonNodeOf(String json) {
        return Jackson.fromJsonString(json, JsonNode.class);
    }

    public static JsonGenerator jsonGeneratorOf(Writer writer) throws IOException {
        return new JsonFactory().createGenerator(writer);
    }

    public static <T> T loadFrom(File file, Class<T> clazz) throws IOException {
        try {
            return objectMapper.readValue(file, clazz);
        }
        catch (IOException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }

    public static ObjectMapper getObjectMapper() {
        return objectMapper;
    }

    public static ObjectWriter getWriter() {
        return writer;
    }

    public static ObjectWriter getPrettywriter() {
        return prettyWriter;
    }

    static {
        objectMapper.configure(JsonParser.Feature.ALLOW_COMMENTS, true);
        objectMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        writer = objectMapper.writer();
        prettyWriter = objectMapper.writerWithDefaultPrettyPrinter();
    }
}

