/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.fs.s3presto.shaded.org.apache.hadoop.hdfs.tools;

import java.io.IOException;
import java.net.InetSocketAddress;
import org.apache.flink.fs.s3presto.shaded.com.facebook.presto.hadoop.$internal.com.google.protobuf.InvalidProtocolBufferException;
import org.apache.flink.fs.s3presto.shaded.com.facebook.presto.hadoop.$internal.org.apache.commons.logging.Log;
import org.apache.flink.fs.s3presto.shaded.com.facebook.presto.hadoop.$internal.org.apache.commons.logging.LogFactory;
import org.apache.flink.fs.s3presto.shaded.org.apache.hadoop.HadoopIllegalArgumentException;
import org.apache.flink.fs.s3presto.shaded.org.apache.hadoop.classification.InterfaceAudience;
import org.apache.flink.fs.s3presto.shaded.org.apache.hadoop.conf.Configuration;
import org.apache.flink.fs.s3presto.shaded.org.apache.hadoop.ha.HAServiceTarget;
import org.apache.flink.fs.s3presto.shaded.org.apache.hadoop.ha.ZKFailoverController;
import org.apache.flink.fs.s3presto.shaded.org.apache.hadoop.hdfs.DFSUtil;
import org.apache.flink.fs.s3presto.shaded.org.apache.hadoop.hdfs.HAUtil;
import org.apache.flink.fs.s3presto.shaded.org.apache.hadoop.hdfs.HDFSPolicyProvider;
import org.apache.flink.fs.s3presto.shaded.org.apache.hadoop.hdfs.HdfsConfiguration;
import org.apache.flink.fs.s3presto.shaded.org.apache.hadoop.hdfs.server.namenode.NameNode;
import org.apache.flink.fs.s3presto.shaded.org.apache.hadoop.hdfs.server.namenode.ha.proto.HAZKInfoProtos;
import org.apache.flink.fs.s3presto.shaded.org.apache.hadoop.hdfs.tools.DFSHAAdmin;
import org.apache.flink.fs.s3presto.shaded.org.apache.hadoop.hdfs.tools.NNHAServiceTarget;
import org.apache.flink.fs.s3presto.shaded.org.apache.hadoop.ipc.Server;
import org.apache.flink.fs.s3presto.shaded.org.apache.hadoop.security.AccessControlException;
import org.apache.flink.fs.s3presto.shaded.org.apache.hadoop.security.SecurityUtil;
import org.apache.flink.fs.s3presto.shaded.org.apache.hadoop.security.UserGroupInformation;
import org.apache.flink.fs.s3presto.shaded.org.apache.hadoop.security.authorize.AccessControlList;
import org.apache.flink.fs.s3presto.shaded.org.apache.hadoop.security.authorize.PolicyProvider;
import org.apache.flink.fs.s3presto.shaded.org.apache.hadoop.util.GenericOptionsParser;
import org.apache.flink.fs.s3presto.shaded.org.apache.hadoop.util.StringUtils;

@InterfaceAudience.Private
public class DFSZKFailoverController
extends ZKFailoverController {
    private static final Log LOG = LogFactory.getLog(DFSZKFailoverController.class);
    private final AccessControlList adminAcl;
    private final NNHAServiceTarget localNNTarget;

    @Override
    protected HAServiceTarget dataToTarget(byte[] data) {
        HAZKInfoProtos.ActiveNodeInfo proto;
        try {
            proto = HAZKInfoProtos.ActiveNodeInfo.parseFrom(data);
        }
        catch (InvalidProtocolBufferException e) {
            throw new RuntimeException("Invalid data in ZK: " + StringUtils.byteToHexString(data));
        }
        NNHAServiceTarget ret = new NNHAServiceTarget(this.conf, proto.getNameserviceId(), proto.getNamenodeId());
        InetSocketAddress addressFromProtobuf = new InetSocketAddress(proto.getHostname(), proto.getPort());
        if (!addressFromProtobuf.equals(ret.getAddress())) {
            throw new RuntimeException("Mismatched address stored in ZK for " + ret + ": Stored protobuf was " + proto + ", address from our own " + "configuration for this NameNode was " + ret.getAddress());
        }
        ret.setZkfcPort(proto.getZkfcPort());
        return ret;
    }

    @Override
    protected byte[] targetToData(HAServiceTarget target) {
        InetSocketAddress addr = target.getAddress();
        return HAZKInfoProtos.ActiveNodeInfo.newBuilder().setHostname(addr.getHostName()).setPort(addr.getPort()).setZkfcPort(target.getZKFCAddress().getPort()).setNameserviceId(this.localNNTarget.getNameServiceId()).setNamenodeId(this.localNNTarget.getNameNodeId()).build().toByteArray();
    }

    @Override
    protected InetSocketAddress getRpcAddressToBindTo() {
        int zkfcPort = DFSZKFailoverController.getZkfcPort(this.conf);
        return new InetSocketAddress(this.localTarget.getAddress().getAddress(), zkfcPort);
    }

    @Override
    protected PolicyProvider getPolicyProvider() {
        return new HDFSPolicyProvider();
    }

    static int getZkfcPort(Configuration conf) {
        return conf.getInt("dfs.ha.zkfc.port", 8019);
    }

    public static DFSZKFailoverController create(Configuration conf) {
        String nsId;
        Configuration localNNConf = DFSHAAdmin.addSecurityConfiguration(conf);
        if (!HAUtil.isHAEnabled(localNNConf, nsId = DFSUtil.getNamenodeNameServiceId(conf))) {
            throw new HadoopIllegalArgumentException("HA is not enabled for this namenode.");
        }
        String nnId = HAUtil.getNameNodeId(localNNConf, nsId);
        if (nnId == null) {
            String msg = "Could not get the namenode ID of this node. You may run zkfc on the node other than namenode.";
            throw new HadoopIllegalArgumentException(msg);
        }
        NameNode.initializeGenericKeys(localNNConf, nsId, nnId);
        DFSUtil.setGenericConf(localNNConf, nsId, nnId, ZKFC_CONF_KEYS);
        NNHAServiceTarget localTarget = new NNHAServiceTarget(localNNConf, nsId, nnId);
        return new DFSZKFailoverController(localNNConf, localTarget);
    }

    private DFSZKFailoverController(Configuration conf, NNHAServiceTarget localTarget) {
        super(conf, localTarget);
        this.localNNTarget = localTarget;
        this.adminAcl = new AccessControlList(conf.get("dfs.cluster.administrators", " "));
        LOG.info("Failover controller configured for NameNode " + localTarget);
    }

    @Override
    protected void initRPC() throws IOException {
        super.initRPC();
        this.localNNTarget.setZkfcPort(this.rpcServer.getAddress().getPort());
    }

    @Override
    public void loginAsFCUser() throws IOException {
        InetSocketAddress socAddr = NameNode.getAddress(this.conf);
        SecurityUtil.login(this.conf, "dfs.namenode.keytab.file", "dfs.namenode.kerberos.principal", socAddr.getHostName());
    }

    @Override
    protected String getScopeInsideParentNode() {
        return this.localNNTarget.getNameServiceId();
    }

    public static void main(String[] args) throws Exception {
        if (DFSUtil.parseHelpArgument(args, "Usage: java zkfc [ -formatZK [-force] [-nonInteractive] ]", System.out, true)) {
            System.exit(0);
        }
        GenericOptionsParser parser = new GenericOptionsParser(new HdfsConfiguration(), args);
        DFSZKFailoverController zkfc = DFSZKFailoverController.create(parser.getConfiguration());
        int retCode = 0;
        try {
            retCode = zkfc.run(parser.getRemainingArgs());
        }
        catch (Throwable t) {
            LOG.fatal("Got a fatal error, exiting now", t);
        }
        System.exit(retCode);
    }

    @Override
    protected void checkRpcAdminAccess() throws IOException, AccessControlException {
        UserGroupInformation ugi = UserGroupInformation.getCurrentUser();
        UserGroupInformation zkfcUgi = UserGroupInformation.getLoginUser();
        if (this.adminAcl.isUserAllowed(ugi) || ugi.getShortUserName().equals(zkfcUgi.getShortUserName())) {
            LOG.info("Allowed RPC access from " + ugi + " at " + Server.getRemoteAddress());
            return;
        }
        String msg = "Disallowed RPC access from " + ugi + " at " + Server.getRemoteAddress() + ". Not listed in " + "dfs.cluster.administrators";
        LOG.warn(msg);
        throw new AccessControlException(msg);
    }
}

