/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.fs.s3presto.shaded.org.apache.hadoop.hdfs.tools;

import java.io.IOException;
import java.util.List;
import org.apache.flink.fs.s3presto.shaded.com.facebook.presto.hadoop.$internal.com.google.common.base.Preconditions;
import org.apache.flink.fs.s3presto.shaded.org.apache.hadoop.conf.Configuration;
import org.apache.flink.fs.s3presto.shaded.org.apache.hadoop.fs.FileSystem;
import org.apache.flink.fs.s3presto.shaded.org.apache.hadoop.hdfs.DFSUtil;
import org.apache.flink.fs.s3presto.shaded.org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.flink.fs.s3presto.shaded.org.apache.hadoop.tools.TableListing;

public class AdminHelper {
    static final int MAX_LINE_WIDTH = 80;
    static final String HELP_COMMAND_NAME = "-help";

    static DistributedFileSystem getDFS(Configuration conf) throws IOException {
        FileSystem fs = FileSystem.get(conf);
        if (!(fs instanceof DistributedFileSystem)) {
            throw new IllegalArgumentException("FileSystem " + fs.getUri() + " is not an HDFS file system");
        }
        return (DistributedFileSystem)fs;
    }

    static String prettifyException(Exception e) {
        return e.getClass().getSimpleName() + ": " + e.getLocalizedMessage().split("\n")[0];
    }

    static TableListing getOptionDescriptionListing() {
        return new TableListing.Builder().addField("").addField("", true).wrapWidth(80).hideHeaders().build();
    }

    static Long parseTtlString(String maxTtlString) throws IOException {
        Long maxTtl = null;
        if (maxTtlString != null) {
            maxTtl = maxTtlString.equalsIgnoreCase("never") ? Long.valueOf(0x1FFFFFFFFFFFFFFFL) : Long.valueOf(DFSUtil.parseRelativeTime(maxTtlString));
        }
        return maxTtl;
    }

    static Long parseLimitString(String limitString) {
        Long limit = null;
        if (limitString != null) {
            limit = limitString.equalsIgnoreCase("unlimited") ? Long.valueOf(Long.MAX_VALUE) : Long.valueOf(Long.parseLong(limitString));
        }
        return limit;
    }

    static Command determineCommand(String commandName, Command[] commands) {
        Preconditions.checkNotNull(commands);
        if (HELP_COMMAND_NAME.equals(commandName)) {
            return new HelpCommand(commands);
        }
        for (Command command : commands) {
            if (!command.getName().equals(commandName)) continue;
            return command;
        }
        return null;
    }

    static void printUsage(boolean longUsage, String toolName, Command[] commands) {
        Preconditions.checkNotNull(commands);
        System.err.println("Usage: bin/hdfs " + toolName + " [COMMAND]");
        HelpCommand helpCommand = new HelpCommand(commands);
        for (Command command : commands) {
            if (longUsage) {
                System.err.print(command.getLongUsage());
                continue;
            }
            System.err.print("          " + command.getShortUsage());
        }
        System.err.print(longUsage ? helpCommand.getLongUsage() : "          " + helpCommand.getShortUsage());
        System.err.println();
    }

    static class HelpCommand
    implements Command {
        private final Command[] commands;

        public HelpCommand(Command[] commands) {
            Preconditions.checkNotNull(commands != null);
            this.commands = commands;
        }

        @Override
        public String getName() {
            return AdminHelper.HELP_COMMAND_NAME;
        }

        @Override
        public String getShortUsage() {
            return "[-help <command-name>]\n";
        }

        @Override
        public String getLongUsage() {
            TableListing listing = AdminHelper.getOptionDescriptionListing();
            listing.addRow("<command-name>", "The command for which to get detailed help. If no command is specified, print detailed help for all commands");
            return this.getShortUsage() + "\n" + "Get detailed help about a command.\n\n" + listing.toString();
        }

        @Override
        public int run(Configuration conf, List<String> args) throws IOException {
            if (args.size() == 0) {
                for (Command command : this.commands) {
                    System.err.println(command.getLongUsage());
                }
                return 0;
            }
            if (args.size() != 1) {
                System.out.println("You must give exactly one argument to -help.");
                return 0;
            }
            String commandName = args.get(0);
            Command command = AdminHelper.determineCommand("-" + commandName, this.commands);
            if (command == null) {
                System.err.print("Unknown command '" + commandName + "'.\n");
                System.err.print("Valid help command names are:\n");
                String separator = "";
                for (Command c : this.commands) {
                    System.err.print(separator + c.getName().substring(1));
                    separator = ", ";
                }
                System.err.print("\n");
                return 1;
            }
            System.err.print(command.getLongUsage());
            return 0;
        }
    }

    static interface Command {
        public String getName();

        public String getShortUsage();

        public String getLongUsage();

        public int run(Configuration var1, List<String> var2) throws IOException;
    }
}

