/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.fs.s3presto.shaded.com.facebook.presto.hive.parquet.dictionary;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.apache.flink.fs.s3presto.shaded.com.facebook.presto.hive.parquet.dictionary.ParquetDictionary;
import org.apache.flink.fs.s3presto.shaded.com.google.common.base.Preconditions;
import parquet.bytes.BytesUtils;
import parquet.column.values.ValuesReader;
import parquet.column.values.rle.RunLengthBitPackingHybridDecoder;
import parquet.io.ParquetDecodingException;
import parquet.io.api.Binary;

public class ParquetDictionaryReader
extends ValuesReader {
    private final ParquetDictionary dictionary;
    private RunLengthBitPackingHybridDecoder decoder;

    public ParquetDictionaryReader(ParquetDictionary dictionary) {
        this.dictionary = dictionary;
    }

    public void initFromPage(int valueCount, byte[] page, int offset) throws IOException {
        Preconditions.checkArgument(page.length > offset, "Attempt to read offset not in the Parquet page");
        ByteArrayInputStream in = new ByteArrayInputStream(page, offset, page.length - offset);
        int bitWidth = BytesUtils.readIntLittleEndianOnOneByte((InputStream)in);
        this.decoder = new RunLengthBitPackingHybridDecoder(bitWidth, in);
    }

    public int readValueDictionaryId() {
        return this.readInt();
    }

    public Binary readBytes() {
        return this.dictionary.decodeToBinary(this.readInt());
    }

    public float readFloat() {
        return this.dictionary.decodeToFloat(this.readInt());
    }

    public double readDouble() {
        return this.dictionary.decodeToDouble(this.readInt());
    }

    public int readInteger() {
        return this.dictionary.decodeToInt(this.readInt());
    }

    public long readLong() {
        return this.dictionary.decodeToLong(this.readInt());
    }

    public void skip() {
        this.readInt();
    }

    private int readInt() {
        try {
            return this.decoder.readInt();
        }
        catch (IOException e) {
            throw new ParquetDecodingException((Throwable)e);
        }
    }
}

