/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.fs.s3presto.shaded.com.facebook.presto.hive.metastore;

import java.util.Optional;
import org.apache.flink.fs.s3presto.shaded.com.facebook.presto.hive.metastore.ExtendedHiveMetastore;
import org.apache.flink.fs.s3presto.shaded.com.facebook.presto.hive.metastore.MetastoreConfig;
import org.apache.flink.fs.s3presto.shaded.com.facebook.presto.hive.metastore.ThriftMetastoreModule;
import org.apache.flink.fs.s3presto.shaded.com.facebook.presto.hive.metastore.file.FileMetastoreModule;
import org.apache.flink.fs.s3presto.shaded.com.google.inject.Binder;
import org.apache.flink.fs.s3presto.shaded.com.google.inject.Module;
import org.apache.flink.fs.s3presto.shaded.io.airlift.configuration.AbstractConfigurationAwareModule;
import org.apache.flink.fs.s3presto.shaded.io.airlift.configuration.ConditionalModule;

public class HiveMetastoreModule
extends AbstractConfigurationAwareModule {
    private final String connectorId;
    private final Optional<ExtendedHiveMetastore> metastore;

    public HiveMetastoreModule(String connectorId, Optional<ExtendedHiveMetastore> metastore) {
        this.connectorId = connectorId;
        this.metastore = metastore;
    }

    @Override
    protected void setup(Binder binder) {
        if (this.metastore.isPresent()) {
            binder.bind(ExtendedHiveMetastore.class).toInstance((Object)this.metastore.get());
        } else {
            this.bindMetastoreModule("thrift", new ThriftMetastoreModule(this.connectorId));
            this.bindMetastoreModule("file", new FileMetastoreModule(this.connectorId));
        }
    }

    private void bindMetastoreModule(String name, Module module) {
        this.install(ConditionalModule.installModuleIf(MetastoreConfig.class, metastore -> name.equalsIgnoreCase(metastore.getMetastoreType()), module));
    }
}

