/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.fs.s3presto.shaded.com.facebook.presto.hive.metastore;

import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.apache.flink.fs.s3presto.shaded.com.facebook.presto.hive.metastore.HivePrivilegeInfo;
import org.apache.flink.fs.s3presto.shaded.org.apache.hadoop.hive.metastore.api.ColumnStatisticsObj;
import org.apache.flink.fs.s3presto.shaded.org.apache.hadoop.hive.metastore.api.Database;
import org.apache.flink.fs.s3presto.shaded.org.apache.hadoop.hive.metastore.api.Partition;
import org.apache.flink.fs.s3presto.shaded.org.apache.hadoop.hive.metastore.api.PrincipalType;
import org.apache.flink.fs.s3presto.shaded.org.apache.hadoop.hive.metastore.api.PrivilegeGrantInfo;
import org.apache.flink.fs.s3presto.shaded.org.apache.hadoop.hive.metastore.api.Table;

public interface HiveMetastore {
    public void createDatabase(Database var1);

    public void dropDatabase(String var1);

    public void alterDatabase(String var1, Database var2);

    public void createTable(Table var1);

    public void dropTable(String var1, String var2, boolean var3);

    public void alterTable(String var1, String var2, Table var3);

    public List<String> getAllDatabases();

    public Optional<List<String>> getAllTables(String var1);

    public Optional<List<String>> getAllViews(String var1);

    public Optional<Database> getDatabase(String var1);

    public void addPartitions(String var1, String var2, List<Partition> var3);

    public void dropPartition(String var1, String var2, List<String> var3, boolean var4);

    public void alterPartition(String var1, String var2, Partition var3);

    public Optional<List<String>> getPartitionNames(String var1, String var2);

    public Optional<List<String>> getPartitionNamesByParts(String var1, String var2, List<String> var3);

    public Optional<Partition> getPartition(String var1, String var2, List<String> var3);

    public List<Partition> getPartitionsByNames(String var1, String var2, List<String> var3);

    public Optional<Table> getTable(String var1, String var2);

    public Optional<Set<ColumnStatisticsObj>> getTableColumnStatistics(String var1, String var2, Set<String> var3);

    public Optional<Map<String, Set<ColumnStatisticsObj>>> getPartitionColumnStatistics(String var1, String var2, Set<String> var3, Set<String> var4);

    public Set<String> getRoles(String var1);

    public Set<HivePrivilegeInfo> getDatabasePrivileges(String var1, String var2);

    public Set<HivePrivilegeInfo> getTablePrivileges(String var1, String var2, String var3);

    public void grantTablePrivileges(String var1, String var2, String var3, Set<PrivilegeGrantInfo> var4);

    public void revokeTablePrivileges(String var1, String var2, String var3, Set<PrivilegeGrantInfo> var4);

    default public boolean isDatabaseOwner(String user, String databaseName) {
        if ("default".equalsIgnoreCase(databaseName)) {
            return true;
        }
        Optional<Database> databaseMetadata = this.getDatabase(databaseName);
        if (!databaseMetadata.isPresent()) {
            return false;
        }
        Database database = databaseMetadata.get();
        if (database.getOwnerType() == PrincipalType.USER && user.equals(database.getOwnerName())) {
            return true;
        }
        return database.getOwnerType() == PrincipalType.ROLE && this.getRoles(user).contains(database.getOwnerName());
    }

    default public boolean isTableOwner(String user, String databaseName, String tableName) {
        Optional<Table> table = this.getTable(databaseName, tableName);
        return table.isPresent() && user.equals(table.get().getOwner());
    }
}

