/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.fs.s3presto.shaded.com.facebook.presto.hive;

import java.io.IOException;
import java.util.concurrent.TimeUnit;
import org.apache.flink.fs.s3presto.shaded.io.airlift.stats.CounterStat;
import org.apache.flink.fs.s3presto.shaded.io.airlift.stats.TimeStat;
import org.apache.flink.fs.s3presto.shaded.org.weakref.jmx.Managed;
import org.apache.flink.fs.s3presto.shaded.org.weakref.jmx.Nested;

public class NamenodeStats {
    private final CallStats listLocatedStatus = new CallStats();
    private final CallStats remoteIteratorNext = new CallStats();

    @Managed
    @Nested
    public CallStats getListLocatedStatus() {
        return this.listLocatedStatus;
    }

    @Managed
    @Nested
    public CallStats getRemoteIteratorNext() {
        return this.remoteIteratorNext;
    }

    public static class CallStats {
        private final TimeStat time = new TimeStat(TimeUnit.MILLISECONDS);
        private final CounterStat totalFailures = new CounterStat();
        private final CounterStat ioExceptions = new CounterStat();

        public TimeStat.BlockTimer time() {
            return this.time.time();
        }

        public void recordException(Exception exception) {
            if (exception instanceof IOException) {
                this.ioExceptions.update(1L);
            }
            this.totalFailures.update(1L);
        }

        @Managed
        @Nested
        public CounterStat getTotalFailures() {
            return this.totalFailures;
        }

        @Managed
        @Nested
        public CounterStat getIoExceptions() {
            return this.ioExceptions;
        }

        @Managed
        @Nested
        public TimeStat getTime() {
            return this.time;
        }
    }
}

