/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.fs.s3presto.shaded.com.facebook.presto.hive;

import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.flink.fs.s3presto.shaded.com.facebook.presto.hive.HiveBucketing;
import org.apache.flink.fs.s3presto.shaded.com.facebook.presto.hive.HiveType;
import org.apache.flink.fs.s3presto.shaded.com.facebook.presto.spi.BucketFunction;
import org.apache.flink.fs.s3presto.shaded.com.facebook.presto.spi.Page;
import org.apache.flink.fs.s3presto.shaded.com.google.common.base.MoreObjects;
import org.apache.flink.fs.s3presto.shaded.org.apache.hadoop.hive.serde2.typeinfo.TypeInfo;

public class HiveBucketFunction
implements BucketFunction {
    private final int bucketCount;
    private final List<TypeInfo> typeInfos;

    public HiveBucketFunction(int bucketCount, List<HiveType> hiveTypes) {
        this.bucketCount = bucketCount;
        this.typeInfos = Objects.requireNonNull(hiveTypes, "hiveTypes is null").stream().map(HiveType::getTypeInfo).collect(Collectors.toList());
    }

    public int getBucket(Page page, int position) {
        return HiveBucketing.getHiveBucket(this.typeInfos, page, position, this.bucketCount);
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).add("bucketCount", this.bucketCount).add("typeInfos", this.typeInfos).toString();
    }
}

