/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.fs.s3presto.shaded.org.apache.htrace.impl;

import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.flink.fs.s3presto.shaded.org.apache.htrace.HTraceConfiguration;
import org.apache.flink.fs.s3presto.shaded.org.apache.htrace.Span;
import org.apache.flink.fs.s3presto.shaded.org.apache.htrace.SpanReceiver;
import org.apache.flink.fs.s3presto.shaded.org.apache.htrace.commons.logging.Log;
import org.apache.flink.fs.s3presto.shaded.org.apache.htrace.commons.logging.LogFactory;

public class LocalFileSpanReceiver
implements SpanReceiver {
    public static final Log LOG = LogFactory.getLog(LocalFileSpanReceiver.class);
    public static final String PATH_KEY = "local-file-span-receiver.path";
    public static final String CAPACITY_KEY = "local-file-span-receiver.capacity";
    public static final int CAPACITY_DEFAULT = 5000;
    public static final long EXECUTOR_TERMINATION_TIMEOUT_DURATION_DEFAULT = 60L;
    private String file;
    private FileWriter fwriter;
    private BufferedWriter bwriter;
    private ExecutorService executor;
    private long executorTerminationTimeoutDuration = 60L;

    public LocalFileSpanReceiver(HTraceConfiguration conf) {
        int capacity = conf.getInt(CAPACITY_KEY, 5000);
        this.file = conf.get(PATH_KEY);
        if (this.file == null || this.file.isEmpty()) {
            throw new IllegalArgumentException("must configure local-file-span-receiver.path");
        }
        this.executor = new ThreadPoolExecutor(1, 1, 0L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(capacity));
        try {
            this.fwriter = new FileWriter(this.file, true);
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe);
        }
        this.bwriter = new BufferedWriter(this.fwriter);
    }

    @Override
    public void receiveSpan(Span span) {
        this.executor.submit(new WriteSpanRunnable(span));
    }

    @Override
    public void close() throws IOException {
        this.executor.shutdown();
        try {
            if (!this.executor.awaitTermination(this.executorTerminationTimeoutDuration, TimeUnit.SECONDS)) {
                LOG.warn("Was not able to process all remaining spans to write upon closing in: " + this.executorTerminationTimeoutDuration + "s");
            }
        }
        catch (InterruptedException e1) {
            LOG.warn("Thread interrupted when terminating executor.", e1);
        }
        try {
            this.fwriter.close();
        }
        catch (IOException e) {
            LOG.error("Error closing filewriter for file: " + this.file, e);
        }
        try {
            this.bwriter.close();
        }
        catch (IOException e) {
            LOG.error("Error closing bufferedwriter for file: " + this.file, e);
        }
    }

    private class WriteSpanRunnable
    implements Runnable {
        public final Span span;

        public WriteSpanRunnable(Span span) {
            this.span = span;
        }

        @Override
        public void run() {
            try {
                LocalFileSpanReceiver.this.bwriter.write(this.span.toJson());
                LocalFileSpanReceiver.this.bwriter.newLine();
                LocalFileSpanReceiver.this.bwriter.flush();
            }
            catch (IOException e) {
                LOG.error("Error when writing to file: " + LocalFileSpanReceiver.this.file, e);
            }
        }
    }
}

