/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.fs.s3presto.shaded.org.apache.hadoop.hdfs.server.namenode;

import java.io.IOException;
import java.security.PrivilegedExceptionAction;
import javax.servlet.http.HttpServletRequest;
import org.apache.flink.fs.s3presto.shaded.org.apache.hadoop.conf.Configuration;
import org.apache.flink.fs.s3presto.shaded.org.apache.hadoop.hdfs.security.token.delegation.DelegationTokenIdentifier;
import org.apache.flink.fs.s3presto.shaded.org.apache.hadoop.hdfs.server.blockmanagement.DatanodeDescriptor;
import org.apache.flink.fs.s3presto.shaded.org.apache.hadoop.hdfs.server.namenode.NameNode;
import org.apache.flink.fs.s3presto.shaded.org.apache.hadoop.hdfs.server.protocol.NamenodeProtocols;
import org.apache.flink.fs.s3presto.shaded.org.apache.hadoop.io.Text;
import org.apache.flink.fs.s3presto.shaded.org.apache.hadoop.security.UserGroupInformation;
import org.apache.flink.fs.s3presto.shaded.org.apache.hadoop.security.token.Token;

class NamenodeJspHelper {
    NamenodeJspHelper() {
    }

    static String getDelegationToken(final NamenodeProtocols nn, HttpServletRequest request, Configuration conf, final UserGroupInformation ugi) throws IOException, InterruptedException {
        Token<DelegationTokenIdentifier> token = ugi.doAs(new PrivilegedExceptionAction<Token<DelegationTokenIdentifier>>(){

            @Override
            public Token<DelegationTokenIdentifier> run() throws IOException {
                return nn.getDelegationToken(new Text(ugi.getUserName()));
            }
        });
        return token == null ? null : token.encodeToUrlString();
    }

    static DatanodeDescriptor getRandomDatanode(NameNode namenode) {
        return (DatanodeDescriptor)namenode.getNamesystem().getBlockManager().getDatanodeManager().getNetworkTopology().chooseRandom("");
    }
}

