/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.fs.s3presto.shaded.org.apache.hadoop.hdfs.protocol;

import java.io.IOException;
import org.apache.flink.fs.s3presto.shaded.org.apache.hadoop.classification.InterfaceAudience;
import org.apache.flink.fs.s3presto.shaded.org.apache.hadoop.classification.InterfaceStability;
import org.apache.flink.fs.s3presto.shaded.org.apache.hadoop.fs.BatchedRemoteIterator;
import org.apache.flink.fs.s3presto.shaded.org.apache.hadoop.hdfs.protocol.ClientProtocol;
import org.apache.flink.fs.s3presto.shaded.org.apache.hadoop.hdfs.protocol.EncryptionZone;
import org.apache.flink.fs.s3presto.shaded.org.apache.htrace.Sampler;
import org.apache.flink.fs.s3presto.shaded.org.apache.htrace.Trace;
import org.apache.flink.fs.s3presto.shaded.org.apache.htrace.TraceScope;

@InterfaceAudience.Private
@InterfaceStability.Evolving
public class EncryptionZoneIterator
extends BatchedRemoteIterator<Long, EncryptionZone> {
    private final ClientProtocol namenode;
    private final Sampler<?> traceSampler;

    public EncryptionZoneIterator(ClientProtocol namenode, Sampler<?> traceSampler) {
        super(0L);
        this.namenode = namenode;
        this.traceSampler = traceSampler;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public BatchedRemoteIterator.BatchedEntries<EncryptionZone> makeRequest(Long prevId) throws IOException {
        try (TraceScope scope = Trace.startSpan("listEncryptionZones", this.traceSampler);){
            BatchedRemoteIterator.BatchedEntries<EncryptionZone> batchedEntries = this.namenode.listEncryptionZones(prevId);
            return batchedEntries;
        }
    }

    @Override
    public Long elementToPrevKey(EncryptionZone entry) {
        return entry.getId();
    }
}

