/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.fs.s3presto.shaded.com.facebook.presto.hive.metastore;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import javax.annotation.concurrent.Immutable;
import org.apache.flink.fs.s3presto.shaded.com.facebook.presto.hive.metastore.Column;
import org.apache.flink.fs.s3presto.shaded.com.facebook.presto.hive.metastore.Storage;
import org.apache.flink.fs.s3presto.shaded.com.fasterxml.jackson.annotation.JsonCreator;
import org.apache.flink.fs.s3presto.shaded.com.fasterxml.jackson.annotation.JsonProperty;
import org.apache.flink.fs.s3presto.shaded.com.google.common.base.MoreObjects;
import org.apache.flink.fs.s3presto.shaded.com.google.common.collect.ImmutableList;
import org.apache.flink.fs.s3presto.shaded.com.google.common.collect.ImmutableMap;

@Immutable
public class Partition {
    private final String databaseName;
    private final String tableName;
    private final List<String> values;
    private final Storage storage;
    private final List<Column> columns;
    private final Map<String, String> parameters;

    @JsonCreator
    public Partition(@JsonProperty(value="databaseName") String databaseName, @JsonProperty(value="tableName") String tableName, @JsonProperty(value="values") List<String> values, @JsonProperty(value="storage") Storage storage, @JsonProperty(value="columns") List<Column> columns, @JsonProperty(value="parameters") Map<String, String> parameters) {
        this.databaseName = Objects.requireNonNull(databaseName, "databaseName is null");
        this.tableName = Objects.requireNonNull(tableName, "tableName is null");
        this.values = ImmutableList.copyOf((Collection)Objects.requireNonNull(values, "values is null"));
        this.storage = Objects.requireNonNull(storage, "storage is null");
        this.columns = ImmutableList.copyOf((Collection)Objects.requireNonNull(columns, "columns is null"));
        this.parameters = ImmutableMap.copyOf(Objects.requireNonNull(parameters, "parameters is null"));
    }

    @JsonProperty
    public String getDatabaseName() {
        return this.databaseName;
    }

    @JsonProperty
    public String getTableName() {
        return this.tableName;
    }

    @JsonProperty
    public List<String> getValues() {
        return this.values;
    }

    @JsonProperty
    public Storage getStorage() {
        return this.storage;
    }

    @JsonProperty
    public List<Column> getColumns() {
        return this.columns;
    }

    @JsonProperty
    public Map<String, String> getParameters() {
        return this.parameters;
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).add("databaseName", this.databaseName).add("tableName", this.tableName).add("values", this.values).toString();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(Partition partition) {
        return new Builder(partition);
    }

    public static class Builder {
        private final Storage.Builder storageBuilder;
        private String databaseName;
        private String tableName;
        private List<String> values;
        private List<Column> columns;
        private Map<String, String> parameters = ImmutableMap.of();

        private Builder() {
            this.storageBuilder = Storage.builder();
        }

        private Builder(Partition partition) {
            this.storageBuilder = Storage.builder(partition.getStorage());
            this.databaseName = partition.getDatabaseName();
            this.tableName = partition.getTableName();
            this.values = partition.getValues();
            this.columns = partition.getColumns();
            this.parameters = partition.getParameters();
        }

        public Builder setDatabaseName(String databaseName) {
            this.databaseName = databaseName;
            return this;
        }

        public Builder setTableName(String tableName) {
            this.tableName = tableName;
            return this;
        }

        public Builder setValues(List<String> values) {
            this.values = values;
            return this;
        }

        public Storage.Builder getStorageBuilder() {
            return this.storageBuilder;
        }

        public Builder withStorage(Consumer<Storage.Builder> consumer) {
            consumer.accept(this.storageBuilder);
            return this;
        }

        public Builder setColumns(List<Column> columns) {
            this.columns = columns;
            return this;
        }

        public Builder setParameters(Map<String, String> parameters) {
            this.parameters = parameters;
            return this;
        }

        public Partition build() {
            return new Partition(this.databaseName, this.tableName, this.values, this.storageBuilder.build(), this.columns, this.parameters);
        }
    }
}

