/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.fs.s3presto.shaded.org.apache.hadoop.security.authentication.server;

import java.io.IOException;
import java.security.Principal;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Enumeration;
import java.util.Locale;
import java.util.Properties;
import java.util.TimeZone;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import javax.servlet.http.HttpServletResponse;
import org.apache.flink.fs.s3presto.shaded.com.facebook.presto.hadoop.$internal.org.slf4j.Logger;
import org.apache.flink.fs.s3presto.shaded.com.facebook.presto.hadoop.$internal.org.slf4j.LoggerFactory;
import org.apache.flink.fs.s3presto.shaded.org.apache.hadoop.classification.InterfaceAudience;
import org.apache.flink.fs.s3presto.shaded.org.apache.hadoop.classification.InterfaceStability;
import org.apache.flink.fs.s3presto.shaded.org.apache.hadoop.security.authentication.client.AuthenticationException;
import org.apache.flink.fs.s3presto.shaded.org.apache.hadoop.security.authentication.server.AuthenticationHandler;
import org.apache.flink.fs.s3presto.shaded.org.apache.hadoop.security.authentication.server.AuthenticationToken;
import org.apache.flink.fs.s3presto.shaded.org.apache.hadoop.security.authentication.server.KerberosAuthenticationHandler;
import org.apache.flink.fs.s3presto.shaded.org.apache.hadoop.security.authentication.server.PseudoAuthenticationHandler;
import org.apache.flink.fs.s3presto.shaded.org.apache.hadoop.security.authentication.util.FileSignerSecretProvider;
import org.apache.flink.fs.s3presto.shaded.org.apache.hadoop.security.authentication.util.RandomSignerSecretProvider;
import org.apache.flink.fs.s3presto.shaded.org.apache.hadoop.security.authentication.util.Signer;
import org.apache.flink.fs.s3presto.shaded.org.apache.hadoop.security.authentication.util.SignerException;
import org.apache.flink.fs.s3presto.shaded.org.apache.hadoop.security.authentication.util.SignerSecretProvider;
import org.apache.flink.fs.s3presto.shaded.org.apache.hadoop.security.authentication.util.ZKSignerSecretProvider;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public class AuthenticationFilter
implements Filter {
    private static Logger LOG = LoggerFactory.getLogger(AuthenticationFilter.class);
    public static final String CONFIG_PREFIX = "config.prefix";
    public static final String AUTH_TYPE = "type";
    public static final String SIGNATURE_SECRET = "signature.secret";
    public static final String SIGNATURE_SECRET_FILE = "signature.secret.file";
    public static final String AUTH_TOKEN_VALIDITY = "token.validity";
    public static final String COOKIE_DOMAIN = "cookie.domain";
    public static final String COOKIE_PATH = "cookie.path";
    public static final String SIGNER_SECRET_PROVIDER = "signer.secret.provider";
    public static final String SIGNER_SECRET_PROVIDER_ATTRIBUTE = "signer.secret.provider.object";
    private Properties config;
    private Signer signer;
    private SignerSecretProvider secretProvider;
    private AuthenticationHandler authHandler;
    private long validity;
    private String cookieDomain;
    private String cookiePath;
    private boolean isInitializedByTomcat;

    public void init(FilterConfig filterConfig) throws ServletException {
        String configPrefix = filterConfig.getInitParameter(CONFIG_PREFIX);
        configPrefix = configPrefix != null ? configPrefix + "." : "";
        this.config = this.getConfiguration(configPrefix, filterConfig);
        String authHandlerName = this.config.getProperty(AUTH_TYPE, null);
        if (authHandlerName == null) {
            throw new ServletException("Authentication type must be specified: simple|kerberos|<class>");
        }
        String authHandlerClassName = authHandlerName.toLowerCase(Locale.ENGLISH).equals("simple") ? PseudoAuthenticationHandler.class.getName() : (authHandlerName.toLowerCase(Locale.ENGLISH).equals("kerberos") ? KerberosAuthenticationHandler.class.getName() : authHandlerName);
        this.validity = Long.parseLong(this.config.getProperty(AUTH_TOKEN_VALIDITY, "36000")) * 1000L;
        this.initializeSecretProvider(filterConfig);
        this.initializeAuthHandler(authHandlerClassName, filterConfig);
        this.cookieDomain = this.config.getProperty(COOKIE_DOMAIN, null);
        this.cookiePath = this.config.getProperty(COOKIE_PATH, null);
    }

    protected void initializeAuthHandler(String authHandlerClassName, FilterConfig filterConfig) throws ServletException {
        try {
            Class<?> klass = Thread.currentThread().getContextClassLoader().loadClass(authHandlerClassName);
            this.authHandler = (AuthenticationHandler)klass.newInstance();
            this.authHandler.init(this.config);
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException ex) {
            throw new ServletException((Throwable)ex);
        }
    }

    protected void initializeSecretProvider(FilterConfig filterConfig) throws ServletException {
        this.secretProvider = (SignerSecretProvider)filterConfig.getServletContext().getAttribute(SIGNER_SECRET_PROVIDER_ATTRIBUTE);
        if (this.secretProvider == null) {
            try {
                this.secretProvider = AuthenticationFilter.constructSecretProvider(filterConfig.getServletContext(), this.config, false);
                this.isInitializedByTomcat = true;
            }
            catch (Exception ex) {
                throw new ServletException((Throwable)ex);
            }
        }
        this.signer = new Signer(this.secretProvider);
    }

    public static SignerSecretProvider constructSecretProvider(ServletContext ctx, Properties config, boolean disallowFallbackToRandomSecretProvider) throws Exception {
        SignerSecretProvider provider;
        String name = config.getProperty(SIGNER_SECRET_PROVIDER, "file");
        long validity = Long.parseLong(config.getProperty(AUTH_TOKEN_VALIDITY, "36000")) * 1000L;
        if (!disallowFallbackToRandomSecretProvider && "file".equals(name) && config.getProperty(SIGNATURE_SECRET_FILE) == null) {
            name = "random";
        }
        if ("file".equals(name)) {
            provider = new FileSignerSecretProvider();
            try {
                provider.init(config, ctx, validity);
            }
            catch (Exception e) {
                if (!disallowFallbackToRandomSecretProvider) {
                    LOG.info("Unable to initialize FileSignerSecretProvider, falling back to use random secrets.");
                    provider = new RandomSignerSecretProvider();
                    provider.init(config, ctx, validity);
                }
                throw e;
            }
        } else if ("random".equals(name)) {
            provider = new RandomSignerSecretProvider();
            provider.init(config, ctx, validity);
        } else if ("zookeeper".equals(name)) {
            provider = new ZKSignerSecretProvider();
            provider.init(config, ctx, validity);
        } else {
            provider = (SignerSecretProvider)Thread.currentThread().getContextClassLoader().loadClass(name).newInstance();
            provider.init(config, ctx, validity);
        }
        return provider;
    }

    protected Properties getConfiguration() {
        return this.config;
    }

    protected AuthenticationHandler getAuthenticationHandler() {
        return this.authHandler;
    }

    protected boolean isRandomSecret() {
        return this.secretProvider.getClass() == RandomSignerSecretProvider.class;
    }

    protected boolean isCustomSignerSecretProvider() {
        Class<?> clazz = this.secretProvider.getClass();
        return clazz != FileSignerSecretProvider.class && clazz != RandomSignerSecretProvider.class && clazz != ZKSignerSecretProvider.class;
    }

    protected long getValidity() {
        return this.validity / 1000L;
    }

    protected String getCookieDomain() {
        return this.cookieDomain;
    }

    protected String getCookiePath() {
        return this.cookiePath;
    }

    public void destroy() {
        if (this.authHandler != null) {
            this.authHandler.destroy();
            this.authHandler = null;
        }
        if (this.secretProvider != null && this.isInitializedByTomcat) {
            this.secretProvider.destroy();
            this.secretProvider = null;
        }
    }

    protected Properties getConfiguration(String configPrefix, FilterConfig filterConfig) throws ServletException {
        Properties props = new Properties();
        Enumeration names = filterConfig.getInitParameterNames();
        while (names.hasMoreElements()) {
            String name = (String)names.nextElement();
            if (!name.startsWith(configPrefix)) continue;
            String value = filterConfig.getInitParameter(name);
            props.put(name.substring(configPrefix.length()), value);
        }
        return props;
    }

    protected String getRequestURL(HttpServletRequest request) {
        StringBuffer sb = request.getRequestURL();
        if (request.getQueryString() != null) {
            sb.append("?").append(request.getQueryString());
        }
        return sb.toString();
    }

    protected AuthenticationToken getToken(HttpServletRequest request) throws IOException, AuthenticationException {
        AuthenticationToken token = null;
        String tokenStr = null;
        Cookie[] cookies = request.getCookies();
        if (cookies != null) {
            for (Cookie cookie : cookies) {
                if (!cookie.getName().equals("hadoop.auth")) continue;
                tokenStr = cookie.getValue();
                try {
                    tokenStr = this.signer.verifyAndExtract(tokenStr);
                    break;
                }
                catch (SignerException ex) {
                    throw new AuthenticationException(ex);
                }
            }
        }
        if (tokenStr != null) {
            token = AuthenticationToken.parse(tokenStr);
            if (!token.getType().equals(this.authHandler.getType())) {
                throw new AuthenticationException("Invalid AuthenticationToken type");
            }
            if (token.isExpired()) {
                throw new AuthenticationException("AuthenticationToken expired");
            }
        }
        return token;
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain filterChain) throws IOException, ServletException {
        boolean unauthorizedResponse = true;
        int errCode = 401;
        AuthenticationException authenticationEx = null;
        Object httpRequest = (HttpServletRequest)request;
        HttpServletResponse httpResponse = (HttpServletResponse)response;
        boolean isHttps = "https".equals(httpRequest.getScheme());
        try {
            AuthenticationToken token;
            boolean newToken = false;
            try {
                token = this.getToken((HttpServletRequest)httpRequest);
            }
            catch (AuthenticationException ex) {
                LOG.warn("AuthenticationToken ignored: " + ex.getMessage());
                authenticationEx = ex;
                token = null;
            }
            if (this.authHandler.managementOperation(token, (HttpServletRequest)httpRequest, httpResponse)) {
                if (token == null) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("Request [{}] triggering authentication", (Object)this.getRequestURL((HttpServletRequest)httpRequest));
                    }
                    if ((token = this.authHandler.authenticate((HttpServletRequest)httpRequest, httpResponse)) != null && token.getExpires() != 0L && token != AuthenticationToken.ANONYMOUS) {
                        token.setExpires(System.currentTimeMillis() + this.getValidity() * 1000L);
                    }
                    newToken = true;
                }
                if (token != null) {
                    unauthorizedResponse = false;
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("Request [{}] user [{}] authenticated", (Object)this.getRequestURL((HttpServletRequest)httpRequest), (Object)token.getUserName());
                    }
                    final AuthenticationToken authToken = token;
                    httpRequest = new HttpServletRequestWrapper((HttpServletRequest)httpRequest){

                        public String getAuthType() {
                            return authToken.getType();
                        }

                        public String getRemoteUser() {
                            return authToken.getUserName();
                        }

                        public Principal getUserPrincipal() {
                            return authToken != AuthenticationToken.ANONYMOUS ? authToken : null;
                        }
                    };
                    if (newToken && !token.isExpired() && token != AuthenticationToken.ANONYMOUS) {
                        String signedToken = this.signer.sign(token.toString());
                        AuthenticationFilter.createAuthCookie(httpResponse, signedToken, this.getCookieDomain(), this.getCookiePath(), token.getExpires(), isHttps);
                    }
                    this.doFilter(filterChain, (HttpServletRequest)httpRequest, httpResponse);
                }
            } else {
                unauthorizedResponse = false;
            }
        }
        catch (AuthenticationException ex) {
            errCode = 403;
            authenticationEx = ex;
            if (LOG.isDebugEnabled()) {
                LOG.debug("Authentication exception: " + ex.getMessage(), ex);
            }
            LOG.warn("Authentication exception: " + ex.getMessage());
        }
        if (unauthorizedResponse && !httpResponse.isCommitted()) {
            AuthenticationFilter.createAuthCookie(httpResponse, "", this.getCookieDomain(), this.getCookiePath(), 0L, isHttps);
            if (errCode == 401 && !httpResponse.containsHeader("WWW-Authenticate")) {
                errCode = 403;
            }
            if (authenticationEx == null) {
                httpResponse.sendError(errCode, "Authentication required");
            } else {
                httpResponse.sendError(errCode, authenticationEx.getMessage());
            }
        }
    }

    protected void doFilter(FilterChain filterChain, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
    }

    public static void createAuthCookie(HttpServletResponse resp, String token, String domain, String path, long expires, boolean isSecure) {
        StringBuilder sb = new StringBuilder("hadoop.auth").append("=");
        if (token != null && token.length() > 0) {
            sb.append("\"").append(token).append("\"");
        }
        if (path != null) {
            sb.append("; Path=").append(path);
        }
        if (domain != null) {
            sb.append("; Domain=").append(domain);
        }
        if (expires >= 0L) {
            Date date = new Date(expires);
            SimpleDateFormat df = new SimpleDateFormat("EEE, dd-MMM-yyyy HH:mm:ss zzz");
            df.setTimeZone(TimeZone.getTimeZone("GMT"));
            sb.append("; Expires=").append(df.format(date));
        }
        if (isSecure) {
            sb.append("; Secure");
        }
        sb.append("; HttpOnly");
        resp.addHeader("Set-Cookie", sb.toString());
    }
}

