/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.fs.s3presto.shaded.org.apache.hadoop.metrics2.lib;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import org.apache.flink.fs.s3presto.shaded.com.facebook.presto.hadoop.$internal.com.google.common.base.Preconditions;
import org.apache.flink.fs.s3presto.shaded.com.facebook.presto.hadoop.$internal.org.apache.commons.logging.Log;
import org.apache.flink.fs.s3presto.shaded.com.facebook.presto.hadoop.$internal.org.apache.commons.logging.LogFactory;
import org.apache.flink.fs.s3presto.shaded.org.apache.hadoop.classification.InterfaceAudience;
import org.apache.flink.fs.s3presto.shaded.org.apache.hadoop.metrics2.MetricsCollector;
import org.apache.flink.fs.s3presto.shaded.org.apache.hadoop.metrics2.MetricsException;
import org.apache.flink.fs.s3presto.shaded.org.apache.hadoop.metrics2.MetricsInfo;
import org.apache.flink.fs.s3presto.shaded.org.apache.hadoop.metrics2.MetricsSource;
import org.apache.flink.fs.s3presto.shaded.org.apache.hadoop.metrics2.annotation.Metric;
import org.apache.flink.fs.s3presto.shaded.org.apache.hadoop.metrics2.annotation.Metrics;
import org.apache.flink.fs.s3presto.shaded.org.apache.hadoop.metrics2.lib.MetricsRegistry;
import org.apache.flink.fs.s3presto.shaded.org.apache.hadoop.metrics2.lib.MutableMetric;
import org.apache.flink.fs.s3presto.shaded.org.apache.hadoop.metrics2.lib.MutableMetricsFactory;
import org.apache.flink.fs.s3presto.shaded.org.apache.hadoop.util.ReflectionUtils;

@InterfaceAudience.Private
public class MetricsSourceBuilder {
    private static final Log LOG = LogFactory.getLog(MetricsSourceBuilder.class);
    private final Object source;
    private final MutableMetricsFactory factory;
    private final MetricsRegistry registry;
    private MetricsInfo info;
    private boolean hasAtMetric = false;
    private boolean hasRegistry = false;

    MetricsSourceBuilder(Object source, MutableMetricsFactory factory) {
        this.source = Preconditions.checkNotNull(source, "source");
        this.factory = Preconditions.checkNotNull(factory, "mutable metrics factory");
        Class<?> cls = source.getClass();
        this.registry = this.initRegistry(source);
        for (Field field : ReflectionUtils.getDeclaredFieldsIncludingInherited(cls)) {
            this.add(source, field);
        }
        for (Method method : ReflectionUtils.getDeclaredMethodsIncludingInherited(cls)) {
            this.add(source, method);
        }
    }

    public MetricsSource build() {
        if (this.source instanceof MetricsSource) {
            if (this.hasAtMetric && !this.hasRegistry) {
                throw new MetricsException("Hybrid metrics: registry required.");
            }
            return (MetricsSource)this.source;
        }
        if (!this.hasAtMetric) {
            throw new MetricsException("No valid @Metric annotation found.");
        }
        return new MetricsSource(){

            @Override
            public void getMetrics(MetricsCollector builder, boolean all) {
                MetricsSourceBuilder.this.registry.snapshot(builder.addRecord(MetricsSourceBuilder.this.registry.info()), all);
            }
        };
    }

    public MetricsInfo info() {
        return this.info;
    }

    private MetricsRegistry initRegistry(Object source) {
        Class<?> cls = source.getClass();
        MetricsRegistry r = null;
        for (Field field : ReflectionUtils.getDeclaredFieldsIncludingInherited(cls)) {
            if (field.getType() != MetricsRegistry.class) continue;
            try {
                field.setAccessible(true);
                r = (MetricsRegistry)field.get(source);
                this.hasRegistry = r != null;
                break;
            }
            catch (Exception e) {
                LOG.warn("Error accessing field " + field, e);
            }
        }
        for (Annotation annotation : cls.getAnnotations()) {
            if (!(annotation instanceof Metrics)) continue;
            Metrics ma = (Metrics)annotation;
            this.info = this.factory.getInfo(cls, ma);
            if (r == null) {
                r = new MetricsRegistry(this.info);
            }
            r.setContext(ma.context());
        }
        if (r == null) {
            return new MetricsRegistry(cls.getSimpleName());
        }
        return r;
    }

    private void add(Object source, Field field) {
        for (Annotation annotation : field.getAnnotations()) {
            block6: {
                if (!(annotation instanceof Metric)) continue;
                try {
                    field.setAccessible(true);
                    if (field.get(source) != null) {
                    }
                    break block6;
                }
                catch (Exception e) {
                    LOG.warn("Error accessing field " + field + " annotated with" + annotation, e);
                }
                continue;
            }
            MutableMetric mutable = this.factory.newForField(field, (Metric)annotation, this.registry);
            if (mutable == null) continue;
            try {
                field.set(source, mutable);
                this.hasAtMetric = true;
            }
            catch (Exception e) {
                throw new MetricsException("Error setting field " + field + " annotated with " + annotation, e);
            }
        }
    }

    private void add(Object source, Method method) {
        for (Annotation annotation : method.getAnnotations()) {
            if (!(annotation instanceof Metric)) continue;
            this.factory.newForMethod(source, method, (Metric)annotation, this.registry);
            this.hasAtMetric = true;
        }
    }
}

