/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.fs.s3presto.shaded.org.apache.hadoop.io.compress;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import org.apache.flink.fs.s3presto.shaded.org.apache.hadoop.classification.InterfaceAudience;
import org.apache.flink.fs.s3presto.shaded.org.apache.hadoop.classification.InterfaceStability;
import org.apache.flink.fs.s3presto.shaded.org.apache.hadoop.io.compress.Decompressor;
import org.apache.flink.fs.s3presto.shaded.org.apache.hadoop.io.compress.DecompressorStream;

@InterfaceAudience.Public
@InterfaceStability.Evolving
public class BlockDecompressorStream
extends DecompressorStream {
    private int originalBlockSize = 0;
    private int noUncompressedBytes = 0;

    public BlockDecompressorStream(InputStream in, Decompressor decompressor, int bufferSize) throws IOException {
        super(in, decompressor, bufferSize);
    }

    public BlockDecompressorStream(InputStream in, Decompressor decompressor) throws IOException {
        super(in, decompressor);
    }

    protected BlockDecompressorStream(InputStream in) throws IOException {
        super(in);
    }

    @Override
    protected int decompress(byte[] b, int off, int len) throws IOException {
        if (this.noUncompressedBytes == this.originalBlockSize) {
            try {
                this.originalBlockSize = this.rawReadInt();
            }
            catch (IOException ioe) {
                return -1;
            }
            this.noUncompressedBytes = 0;
            if (this.originalBlockSize == 0) {
                this.eof = true;
                return -1;
            }
        }
        int n = 0;
        while ((n = this.decompressor.decompress(b, off, len)) == 0) {
            int m;
            if ((this.decompressor.finished() || this.decompressor.needsDictionary()) && this.noUncompressedBytes >= this.originalBlockSize) {
                this.eof = true;
                return -1;
            }
            if (!this.decompressor.needsInput()) continue;
            try {
                m = this.getCompressedData();
            }
            catch (EOFException e) {
                this.eof = true;
                return -1;
            }
            this.decompressor.setInput(this.buffer, 0, m);
        }
        this.noUncompressedBytes += n;
        return n;
    }

    @Override
    protected int getCompressedData() throws IOException {
        int count;
        this.checkStream();
        int len = this.rawReadInt();
        if (len > this.buffer.length) {
            this.buffer = new byte[len];
        }
        int off = 0;
        for (int n = 0; n < len; n += count) {
            count = this.in.read(this.buffer, off + n, len - n);
            if (count >= 0) continue;
            throw new EOFException("Unexpected end of block in input stream");
        }
        return len;
    }

    @Override
    public void resetState() throws IOException {
        this.originalBlockSize = 0;
        this.noUncompressedBytes = 0;
        super.resetState();
    }

    private int rawReadInt() throws IOException {
        int b4;
        int b3;
        int b2;
        int b1 = this.in.read();
        if ((b1 | (b2 = this.in.read()) | (b3 = this.in.read()) | (b4 = this.in.read())) < 0) {
            throw new EOFException();
        }
        return (b1 << 24) + (b2 << 16) + (b3 << 8) + (b4 << 0);
    }
}

