/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.fs.s3presto.shaded.org.apache.hadoop.fs.shell;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.LinkedList;
import java.util.List;
import org.apache.flink.fs.s3presto.shaded.org.apache.hadoop.classification.InterfaceAudience;
import org.apache.flink.fs.s3presto.shaded.org.apache.hadoop.classification.InterfaceStability;
import org.apache.flink.fs.s3presto.shaded.org.apache.hadoop.fs.FSDataInputStream;
import org.apache.flink.fs.s3presto.shaded.org.apache.hadoop.fs.PathIsDirectoryException;
import org.apache.flink.fs.s3presto.shaded.org.apache.hadoop.fs.shell.CommandFactory;
import org.apache.flink.fs.s3presto.shaded.org.apache.hadoop.fs.shell.CommandFormat;
import org.apache.flink.fs.s3presto.shaded.org.apache.hadoop.fs.shell.FsCommand;
import org.apache.flink.fs.s3presto.shaded.org.apache.hadoop.fs.shell.PathData;
import org.apache.flink.fs.s3presto.shaded.org.apache.hadoop.io.IOUtils;

@InterfaceAudience.Private
@InterfaceStability.Unstable
class Tail
extends FsCommand {
    public static final String NAME = "tail";
    public static final String USAGE = "[-f] <file>";
    public static final String DESCRIPTION = "Show the last 1KB of the file.\n-f: Shows appended data as the file grows.\n";
    private long startingOffset = -1024L;
    private boolean follow = false;
    private long followDelay = 5000L;

    Tail() {
    }

    public static void registerCommands(CommandFactory factory) {
        factory.addClass(Tail.class, "-tail");
    }

    @Override
    protected void processOptions(LinkedList<String> args) throws IOException {
        CommandFormat cf = new CommandFormat(1, 1, "f");
        cf.parse(args);
        this.follow = cf.getOpt("f");
    }

    @Override
    protected List<PathData> expandArgument(String arg) throws IOException {
        LinkedList<PathData> items = new LinkedList<PathData>();
        items.add(new PathData(arg, this.getConf()));
        return items;
    }

    @Override
    protected void processPath(PathData item) throws IOException {
        if (item.stat.isDirectory()) {
            throw new PathIsDirectoryException(item.toString());
        }
        long offset = this.dumpFromOffset(item, this.startingOffset);
        while (this.follow) {
            try {
                Thread.sleep(this.followDelay);
            }
            catch (InterruptedException e) {
                break;
            }
            offset = this.dumpFromOffset(item, offset);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long dumpFromOffset(PathData item, long offset) throws IOException {
        long fileSize = item.refreshStatus().getLen();
        if (offset > fileSize) {
            return fileSize;
        }
        if (offset < 0L) {
            offset = Math.max(fileSize + offset, 0L);
        }
        try (FSDataInputStream in = item.fs.open(item.path);){
            in.seek(offset);
            IOUtils.copyBytes((InputStream)in, (OutputStream)System.out, this.getConf(), false);
            offset = in.getPos();
        }
        return offset;
    }
}

