/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.fs.s3presto.shaded.com.facebook.presto.hive;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.ToIntFunction;
import javax.inject.Inject;
import org.apache.flink.fs.s3presto.shaded.com.facebook.presto.hive.HiveBucketFunction;
import org.apache.flink.fs.s3presto.shaded.com.facebook.presto.hive.HiveConnectorId;
import org.apache.flink.fs.s3presto.shaded.com.facebook.presto.hive.HivePartitioningHandle;
import org.apache.flink.fs.s3presto.shaded.com.facebook.presto.hive.HiveSplit;
import org.apache.flink.fs.s3presto.shaded.com.facebook.presto.hive.HiveType;
import org.apache.flink.fs.s3presto.shaded.com.facebook.presto.spi.BucketFunction;
import org.apache.flink.fs.s3presto.shaded.com.facebook.presto.spi.ConnectorSession;
import org.apache.flink.fs.s3presto.shaded.com.facebook.presto.spi.ConnectorSplit;
import org.apache.flink.fs.s3presto.shaded.com.facebook.presto.spi.Node;
import org.apache.flink.fs.s3presto.shaded.com.facebook.presto.spi.NodeManager;
import org.apache.flink.fs.s3presto.shaded.com.facebook.presto.spi.connector.ConnectorNodePartitioningProvider;
import org.apache.flink.fs.s3presto.shaded.com.facebook.presto.spi.connector.ConnectorPartitioningHandle;
import org.apache.flink.fs.s3presto.shaded.com.facebook.presto.spi.connector.ConnectorTransactionHandle;
import org.apache.flink.fs.s3presto.shaded.com.facebook.presto.spi.type.Type;
import org.apache.flink.fs.s3presto.shaded.com.google.common.collect.ImmutableMap;

public class HiveNodePartitioningProvider
implements ConnectorNodePartitioningProvider {
    private final String connectorId;
    private final NodeManager nodeManager;

    @Inject
    public HiveNodePartitioningProvider(HiveConnectorId connectorId, NodeManager nodeManager) {
        this.connectorId = Objects.requireNonNull(connectorId, "connectorId is null").toString();
        this.nodeManager = Objects.requireNonNull(nodeManager, "nodeManager is null");
    }

    public BucketFunction getBucketFunction(ConnectorTransactionHandle transactionHandle, ConnectorSession session, ConnectorPartitioningHandle partitioningHandle, List<Type> partitionChannelTypes, int bucketCount) {
        HivePartitioningHandle handle = (HivePartitioningHandle)partitioningHandle;
        List<HiveType> hiveTypes = handle.getHiveTypes();
        return new HiveBucketFunction(bucketCount, hiveTypes);
    }

    public Map<Integer, Node> getBucketToNode(ConnectorTransactionHandle transactionHandle, ConnectorSession session, ConnectorPartitioningHandle partitioningHandle) {
        HivePartitioningHandle handle = (HivePartitioningHandle)partitioningHandle;
        List nodes = HiveNodePartitioningProvider.shuffle(this.nodeManager.getRequiredWorkerNodes());
        int bucketCount = handle.getBucketCount();
        ImmutableMap.Builder distribution = ImmutableMap.builder();
        for (int i = 0; i < bucketCount; ++i) {
            distribution.put(i, nodes.get(i % nodes.size()));
        }
        return distribution.build();
    }

    public ToIntFunction<ConnectorSplit> getSplitBucketFunction(ConnectorTransactionHandle transactionHandle, ConnectorSession session, ConnectorPartitioningHandle partitioningHandle) {
        return value -> ((HiveSplit)value).getBucketNumber().getAsInt();
    }

    private static <T> List<T> shuffle(Collection<T> items) {
        ArrayList<T> list = new ArrayList<T>(items);
        Collections.shuffle(list);
        return list;
    }
}

