/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.fs.s3presto.shaded.org.weakref.jmx.internal.guava.collect;

import java.io.Serializable;
import java.util.Comparator;
import javax.annotation.Nullable;
import org.apache.flink.fs.s3presto.shaded.org.weakref.jmx.internal.guava.annotations.GwtCompatible;
import org.apache.flink.fs.s3presto.shaded.org.weakref.jmx.internal.guava.base.Preconditions;
import org.apache.flink.fs.s3presto.shaded.org.weakref.jmx.internal.guava.collect.Ordering;

@GwtCompatible(serializable=true)
final class ComparatorOrdering<T>
extends Ordering<T>
implements Serializable {
    final Comparator<T> comparator;
    private static final long serialVersionUID = 0L;

    ComparatorOrdering(Comparator<T> comparator) {
        this.comparator = Preconditions.checkNotNull(comparator);
    }

    @Override
    public int compare(T a, T b) {
        return this.comparator.compare(a, b);
    }

    @Override
    public boolean equals(@Nullable Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof ComparatorOrdering) {
            ComparatorOrdering that = (ComparatorOrdering)object;
            return this.comparator.equals(that.comparator);
        }
        return false;
    }

    public int hashCode() {
        return this.comparator.hashCode();
    }

    public String toString() {
        return this.comparator.toString();
    }
}

