/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.fs.s3presto.shaded.org.weakref.jmx;

import java.lang.annotation.Annotation;
import org.apache.flink.fs.s3presto.shaded.com.google.inject.name.Named;
import org.apache.flink.fs.s3presto.shaded.org.weakref.jmx.ObjectNameBuilder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ObjectNames {
    private ObjectNames() {
    }

    public static String generatedNameOf(Class<?> clazz) {
        return ObjectNames.builder(clazz).build();
    }

    public static String generatedNameOf(Class<?> clazz, Annotation annotation) {
        return ObjectNames.builder(clazz, annotation).build();
    }

    public static String generatedNameOf(Class<?> clazz, Class<? extends Annotation> annotationClass) {
        return ObjectNames.builder(clazz, annotationClass).build();
    }

    public static String generatedNameOf(Class<?> clazz, Named named) {
        return ObjectNames.builder(clazz, named).build();
    }

    public static String generatedNameOf(Class<?> clazz, String name) {
        return ObjectNames.builder(clazz, name).build();
    }

    static String quoteValueIfNecessary(String name) {
        boolean needQuote = false;
        StringBuilder builder = new StringBuilder("\"");
        block6: for (int i = 0; i < name.length(); ++i) {
            char c = name.charAt(i);
            switch (c) {
                case ',': 
                case ':': 
                case '=': {
                    needQuote = true;
                    builder.append(c);
                    continue block6;
                }
                case '\"': 
                case '*': 
                case '?': {
                    needQuote = true;
                    builder.append('\\');
                    builder.append(c);
                    continue block6;
                }
                case '\n': {
                    needQuote = true;
                    builder.append("\\n");
                    continue block6;
                }
                case '\\': {
                    builder.append("\\\\");
                    continue block6;
                }
                default: {
                    builder.append(c);
                }
            }
        }
        if (needQuote) {
            name = builder.append('\"').toString();
        }
        return name;
    }

    public static ObjectNameBuilder builder(Class<?> clazz) {
        return new ObjectNameBuilder(clazz.getPackage().getName()).withProperty("name", clazz.getSimpleName());
    }

    public static ObjectNameBuilder builder(Class<?> clazz, Annotation annotation) {
        return ObjectNames.builder(clazz, annotation.annotationType());
    }

    public static ObjectNameBuilder builder(Class<?> clazz, Class<? extends Annotation> annotationClass) {
        return ObjectNames.builder(clazz, annotationClass.getSimpleName());
    }

    public static ObjectNameBuilder builder(Class<?> clazz, Named named) {
        return ObjectNames.builder(clazz, named.value());
    }

    public static ObjectNameBuilder builder(Class<?> clazz, String name) {
        return new ObjectNameBuilder(clazz.getPackage().getName()).withProperty("type", clazz.getSimpleName()).withProperty("name", name);
    }
}

