/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.fs.s3presto.shaded.org.apache.hadoop.util;

import java.io.Closeable;
import java.util.concurrent.TimeUnit;

public class StopWatch
implements Closeable {
    private boolean isStarted;
    private long startNanos;
    private long currentElapsedNanos;

    public boolean isRunning() {
        return this.isStarted;
    }

    public StopWatch start() {
        if (this.isStarted) {
            throw new IllegalStateException("StopWatch is already running");
        }
        this.isStarted = true;
        this.startNanos = System.nanoTime();
        return this;
    }

    public StopWatch stop() {
        if (!this.isStarted) {
            throw new IllegalStateException("StopWatch is already stopped");
        }
        long now = System.nanoTime();
        this.isStarted = false;
        this.currentElapsedNanos += now - this.startNanos;
        return this;
    }

    public StopWatch reset() {
        this.currentElapsedNanos = 0L;
        this.isStarted = false;
        return this;
    }

    public long now(TimeUnit timeUnit) {
        return timeUnit.convert(this.now(), TimeUnit.NANOSECONDS);
    }

    public long now() {
        return this.isStarted ? System.nanoTime() - this.startNanos + this.currentElapsedNanos : this.currentElapsedNanos;
    }

    public String toString() {
        return String.valueOf(this.now());
    }

    @Override
    public void close() {
        if (this.isStarted) {
            this.stop();
        }
    }
}

