/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.fs.s3presto.shaded.org.apache.hadoop.util;

import java.io.File;
import java.io.IOException;
import org.apache.flink.fs.s3presto.shaded.org.apache.hadoop.classification.InterfaceAudience;
import org.apache.flink.fs.s3presto.shaded.org.apache.hadoop.classification.InterfaceStability;
import org.apache.flink.fs.s3presto.shaded.org.apache.hadoop.fs.FileUtil;
import org.apache.flink.fs.s3presto.shaded.org.apache.hadoop.fs.LocalFileSystem;
import org.apache.flink.fs.s3presto.shaded.org.apache.hadoop.fs.Path;
import org.apache.flink.fs.s3presto.shaded.org.apache.hadoop.fs.permission.FsPermission;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public class DiskChecker {
    public static boolean mkdirsWithExistsCheck(File dir) {
        if (dir.mkdir() || dir.exists()) {
            return true;
        }
        File canonDir = null;
        try {
            canonDir = dir.getCanonicalFile();
        }
        catch (IOException e) {
            return false;
        }
        String parent = canonDir.getParent();
        return parent != null && DiskChecker.mkdirsWithExistsCheck(new File(parent)) && (canonDir.mkdir() || canonDir.exists());
    }

    public static void checkDirs(File dir) throws DiskErrorException {
        DiskChecker.checkDir(dir);
        for (File child : dir.listFiles()) {
            if (!child.isDirectory()) continue;
            DiskChecker.checkDirs(child);
        }
    }

    public static void checkDir(File dir) throws DiskErrorException {
        if (!DiskChecker.mkdirsWithExistsCheck(dir)) {
            throw new DiskErrorException("Cannot create directory: " + dir.toString());
        }
        DiskChecker.checkDirAccess(dir);
    }

    public static void mkdirsWithExistsAndPermissionCheck(LocalFileSystem localFS, Path dir, FsPermission expected) throws IOException {
        File directory = localFS.pathToFile(dir);
        boolean created = false;
        if (!directory.exists()) {
            created = DiskChecker.mkdirsWithExistsCheck(directory);
        }
        if (created || !localFS.getFileStatus(dir).getPermission().equals(expected)) {
            localFS.setPermission(dir, expected);
        }
    }

    public static void checkDir(LocalFileSystem localFS, Path dir, FsPermission expected) throws DiskErrorException, IOException {
        DiskChecker.mkdirsWithExistsAndPermissionCheck(localFS, dir, expected);
        DiskChecker.checkDirAccess(localFS.pathToFile(dir));
    }

    private static void checkDirAccess(File dir) throws DiskErrorException {
        if (!dir.isDirectory()) {
            throw new DiskErrorException("Not a directory: " + dir.toString());
        }
        DiskChecker.checkAccessByFileMethods(dir);
    }

    private static void checkAccessByFileMethods(File dir) throws DiskErrorException {
        if (!FileUtil.canRead(dir)) {
            throw new DiskErrorException("Directory is not readable: " + dir.toString());
        }
        if (!FileUtil.canWrite(dir)) {
            throw new DiskErrorException("Directory is not writable: " + dir.toString());
        }
        if (!FileUtil.canExecute(dir)) {
            throw new DiskErrorException("Directory is not executable: " + dir.toString());
        }
    }

    public static class DiskOutOfSpaceException
    extends IOException {
        public DiskOutOfSpaceException(String msg) {
            super(msg);
        }
    }

    public static class DiskErrorException
    extends IOException {
        public DiskErrorException(String msg) {
            super(msg);
        }

        public DiskErrorException(String msg, Throwable cause) {
            super(msg, cause);
        }
    }
}

