/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.fs.s3presto.shaded.org.apache.hadoop.record;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PushbackReader;
import java.io.UnsupportedEncodingException;
import org.apache.flink.fs.s3presto.shaded.org.apache.hadoop.classification.InterfaceAudience;
import org.apache.flink.fs.s3presto.shaded.org.apache.hadoop.classification.InterfaceStability;
import org.apache.flink.fs.s3presto.shaded.org.apache.hadoop.record.Buffer;
import org.apache.flink.fs.s3presto.shaded.org.apache.hadoop.record.Index;
import org.apache.flink.fs.s3presto.shaded.org.apache.hadoop.record.RecordInput;
import org.apache.flink.fs.s3presto.shaded.org.apache.hadoop.record.Utils;

@Deprecated
@InterfaceAudience.Public
@InterfaceStability.Stable
public class CsvRecordInput
implements RecordInput {
    private PushbackReader stream;

    private void throwExceptionOnError(String tag) throws IOException {
        throw new IOException("Error deserializing " + tag);
    }

    private String readField(String tag) throws IOException {
        try {
            StringBuilder buf = new StringBuilder();
            while (true) {
                char c = (char)this.stream.read();
                switch (c) {
                    case ',': {
                        return buf.toString();
                    }
                    case '\n': 
                    case '\r': 
                    case '}': {
                        this.stream.unread(c);
                        return buf.toString();
                    }
                }
                buf.append(c);
            }
        }
        catch (IOException ex) {
            throw new IOException("Error reading " + tag);
        }
    }

    public CsvRecordInput(InputStream in) {
        try {
            this.stream = new PushbackReader(new InputStreamReader(in, "UTF-8"));
        }
        catch (UnsupportedEncodingException ex) {
            throw new RuntimeException(ex);
        }
    }

    @Override
    public byte readByte(String tag) throws IOException {
        return (byte)this.readLong(tag);
    }

    @Override
    public boolean readBool(String tag) throws IOException {
        String sval = this.readField(tag);
        return "T".equals(sval);
    }

    @Override
    public int readInt(String tag) throws IOException {
        return (int)this.readLong(tag);
    }

    @Override
    public long readLong(String tag) throws IOException {
        String sval = this.readField(tag);
        try {
            long lval = Long.parseLong(sval);
            return lval;
        }
        catch (NumberFormatException ex) {
            throw new IOException("Error deserializing " + tag);
        }
    }

    @Override
    public float readFloat(String tag) throws IOException {
        return (float)this.readDouble(tag);
    }

    @Override
    public double readDouble(String tag) throws IOException {
        String sval = this.readField(tag);
        try {
            double dval = Double.parseDouble(sval);
            return dval;
        }
        catch (NumberFormatException ex) {
            throw new IOException("Error deserializing " + tag);
        }
    }

    @Override
    public String readString(String tag) throws IOException {
        String sval = this.readField(tag);
        return Utils.fromCSVString(sval);
    }

    @Override
    public Buffer readBuffer(String tag) throws IOException {
        String sval = this.readField(tag);
        return Utils.fromCSVBuffer(sval);
    }

    @Override
    public void startRecord(String tag) throws IOException {
        if (tag != null && !tag.isEmpty()) {
            char c1 = (char)this.stream.read();
            char c2 = (char)this.stream.read();
            if (c1 != 's' || c2 != '{') {
                throw new IOException("Error deserializing " + tag);
            }
        }
    }

    @Override
    public void endRecord(String tag) throws IOException {
        char c = (char)this.stream.read();
        if (tag == null || tag.isEmpty()) {
            if (c != '\n' && c != '\r') {
                throw new IOException("Error deserializing record.");
            }
            return;
        }
        if (c != '}') {
            throw new IOException("Error deserializing " + tag);
        }
        c = (char)this.stream.read();
        if (c != ',') {
            this.stream.unread(c);
        }
    }

    @Override
    public Index startVector(String tag) throws IOException {
        char c1 = (char)this.stream.read();
        char c2 = (char)this.stream.read();
        if (c1 != 'v' || c2 != '{') {
            throw new IOException("Error deserializing " + tag);
        }
        return new CsvIndex();
    }

    @Override
    public void endVector(String tag) throws IOException {
        char c = (char)this.stream.read();
        if (c != '}') {
            throw new IOException("Error deserializing " + tag);
        }
        c = (char)this.stream.read();
        if (c != ',') {
            this.stream.unread(c);
        }
    }

    @Override
    public Index startMap(String tag) throws IOException {
        char c1 = (char)this.stream.read();
        char c2 = (char)this.stream.read();
        if (c1 != 'm' || c2 != '{') {
            throw new IOException("Error deserializing " + tag);
        }
        return new CsvIndex();
    }

    @Override
    public void endMap(String tag) throws IOException {
        char c = (char)this.stream.read();
        if (c != '}') {
            throw new IOException("Error deserializing " + tag);
        }
        c = (char)this.stream.read();
        if (c != ',') {
            this.stream.unread(c);
        }
    }

    private class CsvIndex
    implements Index {
        private CsvIndex() {
        }

        @Override
        public boolean done() {
            int c = 0;
            try {
                c = (char)CsvRecordInput.this.stream.read();
                CsvRecordInput.this.stream.unread(c);
            }
            catch (IOException iOException) {
                // empty catch block
            }
            return c == 125;
        }

        @Override
        public void incr() {
        }
    }
}

