/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.fs.s3presto.shaded.org.apache.hadoop.metrics.jvm;

import java.lang.management.GarbageCollectorMXBean;
import java.lang.management.ManagementFactory;
import java.lang.management.MemoryMXBean;
import java.lang.management.MemoryUsage;
import java.lang.management.ThreadInfo;
import java.lang.management.ThreadMXBean;
import java.util.List;
import org.apache.flink.fs.s3presto.shaded.com.facebook.presto.hadoop.$internal.org.apache.commons.logging.Log;
import org.apache.flink.fs.s3presto.shaded.com.facebook.presto.hadoop.$internal.org.apache.commons.logging.LogFactory;
import org.apache.flink.fs.s3presto.shaded.org.apache.hadoop.classification.InterfaceAudience;
import org.apache.flink.fs.s3presto.shaded.org.apache.hadoop.classification.InterfaceStability;
import org.apache.flink.fs.s3presto.shaded.org.apache.hadoop.metrics.MetricsContext;
import org.apache.flink.fs.s3presto.shaded.org.apache.hadoop.metrics.MetricsRecord;
import org.apache.flink.fs.s3presto.shaded.org.apache.hadoop.metrics.MetricsUtil;
import org.apache.flink.fs.s3presto.shaded.org.apache.hadoop.metrics.Updater;
import org.apache.flink.fs.s3presto.shaded.org.apache.hadoop.metrics.jvm.EventCounter;

@InterfaceAudience.Private
@InterfaceStability.Evolving
public class JvmMetrics
implements Updater {
    private static final float M = 1048576.0f;
    private static JvmMetrics theInstance = null;
    private static Log log = LogFactory.getLog(JvmMetrics.class);
    private MetricsRecord metrics;
    private long gcCount = 0L;
    private long gcTimeMillis = 0L;
    private long fatalCount = 0L;
    private long errorCount = 0L;
    private long warnCount = 0L;
    private long infoCount = 0L;

    public static synchronized JvmMetrics init(String processName, String sessionId) {
        return JvmMetrics.init(processName, sessionId, "metrics");
    }

    public static synchronized JvmMetrics init(String processName, String sessionId, String recordName) {
        if (theInstance != null) {
            log.info("Cannot initialize JVM Metrics with processName=" + processName + ", sessionId=" + sessionId + " - already initialized");
        } else {
            log.info("Initializing JVM Metrics with processName=" + processName + ", sessionId=" + sessionId);
            theInstance = new JvmMetrics(processName, sessionId, recordName);
        }
        return theInstance;
    }

    private JvmMetrics(String processName, String sessionId, String recordName) {
        MetricsContext context = MetricsUtil.getContext("jvm");
        this.metrics = MetricsUtil.createRecord(context, recordName);
        this.metrics.setTag("processName", processName);
        this.metrics.setTag("sessionId", sessionId);
        context.registerUpdater(this);
    }

    @Override
    public void doUpdates(MetricsContext context) {
        this.doMemoryUpdates();
        this.doGarbageCollectionUpdates();
        this.doThreadUpdates();
        this.doEventCountUpdates();
        this.metrics.update();
    }

    private void doMemoryUpdates() {
        MemoryMXBean memoryMXBean = ManagementFactory.getMemoryMXBean();
        MemoryUsage memNonHeap = memoryMXBean.getNonHeapMemoryUsage();
        MemoryUsage memHeap = memoryMXBean.getHeapMemoryUsage();
        Runtime runtime = Runtime.getRuntime();
        this.metrics.setMetric("memNonHeapUsedM", (float)memNonHeap.getUsed() / 1048576.0f);
        this.metrics.setMetric("memNonHeapCommittedM", (float)memNonHeap.getCommitted() / 1048576.0f);
        this.metrics.setMetric("memHeapUsedM", (float)memHeap.getUsed() / 1048576.0f);
        this.metrics.setMetric("memHeapCommittedM", (float)memHeap.getCommitted() / 1048576.0f);
        this.metrics.setMetric("maxMemoryM", (float)runtime.maxMemory() / 1048576.0f);
    }

    private void doGarbageCollectionUpdates() {
        List<GarbageCollectorMXBean> gcBeans = ManagementFactory.getGarbageCollectorMXBeans();
        long count = 0L;
        long timeMillis = 0L;
        for (GarbageCollectorMXBean gcBean : gcBeans) {
            count += gcBean.getCollectionCount();
            timeMillis += gcBean.getCollectionTime();
        }
        this.metrics.incrMetric("gcCount", (int)(count - this.gcCount));
        this.metrics.incrMetric("gcTimeMillis", (int)(timeMillis - this.gcTimeMillis));
        this.gcCount = count;
        this.gcTimeMillis = timeMillis;
    }

    private void doThreadUpdates() {
        ThreadMXBean threadMXBean = ManagementFactory.getThreadMXBean();
        long[] threadIds = threadMXBean.getAllThreadIds();
        ThreadInfo[] threadInfos = threadMXBean.getThreadInfo(threadIds, 0);
        int threadsNew = 0;
        int threadsRunnable = 0;
        int threadsBlocked = 0;
        int threadsWaiting = 0;
        int threadsTimedWaiting = 0;
        int threadsTerminated = 0;
        for (ThreadInfo threadInfo : threadInfos) {
            if (threadInfo == null) continue;
            Thread.State state = threadInfo.getThreadState();
            if (state == Thread.State.NEW) {
                ++threadsNew;
                continue;
            }
            if (state == Thread.State.RUNNABLE) {
                ++threadsRunnable;
                continue;
            }
            if (state == Thread.State.BLOCKED) {
                ++threadsBlocked;
                continue;
            }
            if (state == Thread.State.WAITING) {
                ++threadsWaiting;
                continue;
            }
            if (state == Thread.State.TIMED_WAITING) {
                ++threadsTimedWaiting;
                continue;
            }
            if (state != Thread.State.TERMINATED) continue;
            ++threadsTerminated;
        }
        this.metrics.setMetric("threadsNew", threadsNew);
        this.metrics.setMetric("threadsRunnable", threadsRunnable);
        this.metrics.setMetric("threadsBlocked", threadsBlocked);
        this.metrics.setMetric("threadsWaiting", threadsWaiting);
        this.metrics.setMetric("threadsTimedWaiting", threadsTimedWaiting);
        this.metrics.setMetric("threadsTerminated", threadsTerminated);
    }

    private void doEventCountUpdates() {
        long newFatal = EventCounter.getFatal();
        long newError = EventCounter.getError();
        long newWarn = EventCounter.getWarn();
        long newInfo = EventCounter.getInfo();
        this.metrics.incrMetric("logFatal", (int)(newFatal - this.fatalCount));
        this.metrics.incrMetric("logError", (int)(newError - this.errorCount));
        this.metrics.incrMetric("logWarn", (int)(newWarn - this.warnCount));
        this.metrics.incrMetric("logInfo", (int)(newInfo - this.infoCount));
        this.fatalCount = newFatal;
        this.errorCount = newError;
        this.warnCount = newWarn;
        this.infoCount = newInfo;
    }
}

