/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.fs.s3presto.shaded.org.apache.hadoop.mapreduce.lib.join;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.PriorityQueue;
import org.apache.flink.fs.s3presto.shaded.org.apache.hadoop.classification.InterfaceAudience;
import org.apache.flink.fs.s3presto.shaded.org.apache.hadoop.classification.InterfaceStability;
import org.apache.flink.fs.s3presto.shaded.org.apache.hadoop.conf.Configurable;
import org.apache.flink.fs.s3presto.shaded.org.apache.hadoop.conf.Configuration;
import org.apache.flink.fs.s3presto.shaded.org.apache.hadoop.io.NullWritable;
import org.apache.flink.fs.s3presto.shaded.org.apache.hadoop.io.Writable;
import org.apache.flink.fs.s3presto.shaded.org.apache.hadoop.io.WritableComparable;
import org.apache.flink.fs.s3presto.shaded.org.apache.hadoop.io.WritableComparator;
import org.apache.flink.fs.s3presto.shaded.org.apache.hadoop.mapreduce.InputSplit;
import org.apache.flink.fs.s3presto.shaded.org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.flink.fs.s3presto.shaded.org.apache.hadoop.mapreduce.lib.join.ComposableRecordReader;
import org.apache.flink.fs.s3presto.shaded.org.apache.hadoop.mapreduce.lib.join.CompositeInputSplit;
import org.apache.flink.fs.s3presto.shaded.org.apache.hadoop.mapreduce.lib.join.ResetableIterator;
import org.apache.flink.fs.s3presto.shaded.org.apache.hadoop.mapreduce.lib.join.TupleWritable;
import org.apache.flink.fs.s3presto.shaded.org.apache.hadoop.util.ReflectionUtils;

@InterfaceAudience.Public
@InterfaceStability.Stable
public abstract class CompositeRecordReader<K extends WritableComparable<?>, V extends Writable, X extends Writable>
extends ComposableRecordReader<K, X>
implements Configurable {
    private int id;
    protected Configuration conf;
    private final ResetableIterator<X> EMPTY = new ResetableIterator.EMPTY<X>();
    private WritableComparator cmp;
    protected Class<? extends WritableComparable> keyclass = null;
    private PriorityQueue<ComposableRecordReader<K, ?>> q;
    protected final JoinCollector jc;
    protected final ComposableRecordReader<K, ? extends V>[] kids;
    protected K key;
    protected X value;

    protected abstract boolean combine(Object[] var1, TupleWritable var2);

    public CompositeRecordReader(int id, int capacity, Class<? extends WritableComparator> cmpcl) throws IOException {
        assert (capacity > 0) : "Invalid capacity";
        this.id = id;
        if (null != cmpcl) {
            this.cmp = ReflectionUtils.newInstance(cmpcl, null);
            this.q = new PriorityQueue(3, new Comparator<ComposableRecordReader<K, ?>>(){

                @Override
                public int compare(ComposableRecordReader<K, ?> o1, ComposableRecordReader<K, ?> o2) {
                    return CompositeRecordReader.this.cmp.compare((WritableComparable)o1.key(), (WritableComparable)o2.key());
                }
            });
        }
        this.jc = new JoinCollector(capacity);
        this.kids = new ComposableRecordReader[capacity];
    }

    @Override
    public void initialize(InputSplit split, TaskAttemptContext context) throws IOException, InterruptedException {
        if (this.kids != null) {
            for (int i = 0; i < this.kids.length; ++i) {
                this.kids[i].initialize(((CompositeInputSplit)split).get(i), context);
                if (this.kids[i].key() == null) continue;
                if (this.keyclass == null) {
                    this.keyclass = this.kids[i].createKey().getClass().asSubclass(WritableComparable.class);
                }
                if (null == this.q) {
                    this.cmp = WritableComparator.get(this.keyclass, this.conf);
                    this.q = new PriorityQueue(3, new Comparator<ComposableRecordReader<K, ?>>(){

                        @Override
                        public int compare(ComposableRecordReader<K, ?> o1, ComposableRecordReader<K, ?> o2) {
                            return CompositeRecordReader.this.cmp.compare((WritableComparable)o1.key(), (WritableComparable)o2.key());
                        }
                    });
                }
                if (!this.keyclass.equals(this.kids[i].key().getClass())) {
                    throw new ClassCastException("Child key classes fail to agree");
                }
                if (!this.kids[i].hasNext()) continue;
                this.q.add(this.kids[i]);
            }
        }
    }

    @Override
    public int id() {
        return this.id;
    }

    @Override
    public void setConf(Configuration conf) {
        this.conf = conf;
    }

    @Override
    public Configuration getConf() {
        return this.conf;
    }

    protected PriorityQueue<ComposableRecordReader<K, ?>> getRecordReaderQueue() {
        return this.q;
    }

    protected WritableComparator getComparator() {
        return this.cmp;
    }

    public void add(ComposableRecordReader<K, ? extends V> rr) throws IOException, InterruptedException {
        this.kids[rr.id()] = rr;
    }

    @Override
    public K key() {
        if (this.jc.hasNext()) {
            return this.jc.key();
        }
        if (!this.q.isEmpty()) {
            return this.q.peek().key();
        }
        return null;
    }

    @Override
    public void key(K key) throws IOException {
        ReflectionUtils.copy(this.conf, this.key(), key);
    }

    @Override
    public K getCurrentKey() {
        return this.key;
    }

    @Override
    public boolean hasNext() {
        return this.jc.hasNext() || !this.q.isEmpty();
    }

    @Override
    public void skip(K key) throws IOException, InterruptedException {
        ArrayList tmp = new ArrayList();
        while (!this.q.isEmpty() && this.cmp.compare((WritableComparable)this.q.peek().key(), (WritableComparable)key) <= 0) {
            tmp.add(this.q.poll());
        }
        for (ComposableRecordReader composableRecordReader : tmp) {
            composableRecordReader.skip(key);
            if (!composableRecordReader.hasNext()) continue;
            this.q.add(composableRecordReader);
        }
    }

    protected abstract ResetableIterator<X> getDelegate();

    @Override
    public void accept(JoinCollector jc, K key) throws IOException, InterruptedException {
        if (this.hasNext() && 0 == this.cmp.compare((WritableComparable)key, (WritableComparable)this.key())) {
            this.fillJoinCollector(this.createKey());
            jc.add(this.id, this.getDelegate());
            return;
        }
        jc.add(this.id, this.EMPTY);
    }

    protected void fillJoinCollector(K iterkey) throws IOException, InterruptedException {
        if (!this.q.isEmpty()) {
            this.q.peek().key(iterkey);
            while (0 == this.cmp.compare((WritableComparable)this.q.peek().key(), (WritableComparable)iterkey)) {
                ComposableRecordReader<K, ?> t = this.q.poll();
                t.accept(this.jc, iterkey);
                if (t.hasNext()) {
                    this.q.add(t);
                    continue;
                }
                if (!this.q.isEmpty()) continue;
                return;
            }
        }
    }

    @Override
    public int compareTo(ComposableRecordReader<K, ?> other) {
        return this.cmp.compare((WritableComparable)this.key(), (WritableComparable)other.key());
    }

    @Override
    protected K createKey() {
        if (this.keyclass == null || this.keyclass.equals(NullWritable.class)) {
            return (K)NullWritable.get();
        }
        return (K)ReflectionUtils.newInstance(this.keyclass, this.getConf());
    }

    protected TupleWritable createTupleWritable() {
        Writable[] vals = new Writable[this.kids.length];
        for (int i = 0; i < vals.length; ++i) {
            vals[i] = this.kids[i].createValue();
        }
        return new TupleWritable(vals);
    }

    @Override
    public X getCurrentValue() throws IOException, InterruptedException {
        return this.value;
    }

    @Override
    public void close() throws IOException {
        if (this.kids != null) {
            for (ComposableRecordReader<K, V> composableRecordReader : this.kids) {
                composableRecordReader.close();
            }
        }
        if (this.jc != null) {
            this.jc.close();
        }
    }

    @Override
    public float getProgress() throws IOException, InterruptedException {
        float ret = 1.0f;
        for (ComposableRecordReader<K, V> composableRecordReader : this.kids) {
            ret = Math.min(ret, composableRecordReader.getProgress());
        }
        return ret;
    }

    public class JoinCollector {
        private K key;
        private ResetableIterator<X>[] iters;
        private int pos = -1;
        private boolean first = true;

        public JoinCollector(int card) {
            this.iters = new ResetableIterator[card];
            for (int i = 0; i < this.iters.length; ++i) {
                this.iters[i] = CompositeRecordReader.this.EMPTY;
            }
        }

        public void add(int id, ResetableIterator<X> i) throws IOException {
            this.iters[id] = i;
        }

        public K key() {
            return this.key;
        }

        public void reset(K key) {
            this.key = key;
            this.first = true;
            this.pos = this.iters.length - 1;
            for (int i = 0; i < this.iters.length; ++i) {
                this.iters[i].reset();
            }
        }

        public void clear() {
            this.key = null;
            this.pos = -1;
            for (int i = 0; i < this.iters.length; ++i) {
                this.iters[i].clear();
                this.iters[i] = CompositeRecordReader.this.EMPTY;
            }
        }

        public boolean hasNext() {
            return this.pos >= 0;
        }

        protected boolean next(TupleWritable val) throws IOException {
            if (this.first) {
                int i = -1;
                this.pos = 0;
                while (this.pos < this.iters.length) {
                    if (this.iters[this.pos].hasNext() && this.iters[this.pos].next(val.get(this.pos))) {
                        i = this.pos;
                        val.setWritten(i);
                    }
                    ++this.pos;
                }
                this.pos = i;
                this.first = false;
                if (this.pos < 0) {
                    this.clear();
                    return false;
                }
                return true;
            }
            while (!(0 > this.pos || this.iters[this.pos].hasNext() && this.iters[this.pos].next(val.get(this.pos)))) {
                --this.pos;
            }
            if (this.pos < 0) {
                this.clear();
                return false;
            }
            val.setWritten(this.pos);
            for (int i = 0; i < this.pos; ++i) {
                if (!this.iters[i].replay(val.get(i))) continue;
                val.setWritten(i);
            }
            while (this.pos + 1 < this.iters.length) {
                ++this.pos;
                this.iters[this.pos].reset();
                if (!this.iters[this.pos].hasNext() || !this.iters[this.pos].next(val.get(this.pos))) continue;
                val.setWritten(this.pos);
            }
            return true;
        }

        public boolean replay(TupleWritable val) throws IOException {
            assert (!this.first);
            boolean ret = false;
            for (int i = 0; i < this.iters.length; ++i) {
                if (!this.iters[i].replay(val.get(i))) continue;
                val.setWritten(i);
                ret = true;
            }
            return ret;
        }

        public void close() throws IOException {
            for (int i = 0; i < this.iters.length; ++i) {
                this.iters[i].close();
            }
        }

        public boolean flush(TupleWritable value) throws IOException {
            while (this.hasNext()) {
                value.clearWritten();
                if (!this.next(value) || !CompositeRecordReader.this.combine(CompositeRecordReader.this.kids, value)) continue;
                return true;
            }
            return false;
        }
    }
}

