/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.fs.s3presto.shaded.org.apache.hadoop.mapreduce.lib.db;

import java.io.IOException;
import java.lang.reflect.Method;
import java.sql.Connection;
import java.sql.SQLException;
import org.apache.flink.fs.s3presto.shaded.com.facebook.presto.hadoop.$internal.org.apache.commons.logging.Log;
import org.apache.flink.fs.s3presto.shaded.com.facebook.presto.hadoop.$internal.org.apache.commons.logging.LogFactory;
import org.apache.flink.fs.s3presto.shaded.org.apache.hadoop.classification.InterfaceAudience;
import org.apache.flink.fs.s3presto.shaded.org.apache.hadoop.classification.InterfaceStability;
import org.apache.flink.fs.s3presto.shaded.org.apache.hadoop.conf.Configuration;
import org.apache.flink.fs.s3presto.shaded.org.apache.hadoop.mapreduce.lib.db.DBConfiguration;
import org.apache.flink.fs.s3presto.shaded.org.apache.hadoop.mapreduce.lib.db.DBInputFormat;
import org.apache.flink.fs.s3presto.shaded.org.apache.hadoop.mapreduce.lib.db.DBRecordReader;
import org.apache.flink.fs.s3presto.shaded.org.apache.hadoop.mapreduce.lib.db.DBWritable;

@InterfaceAudience.Public
@InterfaceStability.Evolving
public class OracleDBRecordReader<T extends DBWritable>
extends DBRecordReader<T> {
    public static final String SESSION_TIMEZONE_KEY = "oracle.sessionTimeZone";
    private static final Log LOG = LogFactory.getLog(OracleDBRecordReader.class);

    public OracleDBRecordReader(DBInputFormat.DBInputSplit split, Class<T> inputClass, Configuration conf, Connection conn, DBConfiguration dbConfig, String cond, String[] fields, String table) throws SQLException {
        super(split, inputClass, conf, conn, dbConfig, cond, fields, table);
        OracleDBRecordReader.setSessionTimeZone(conf, conn);
    }

    @Override
    protected String getSelectQuery() {
        StringBuilder query = new StringBuilder();
        DBConfiguration dbConf = this.getDBConf();
        String conditions = this.getConditions();
        String tableName = this.getTableName();
        String[] fieldNames = this.getFieldNames();
        if (dbConf.getInputQuery() == null) {
            String orderBy;
            query.append("SELECT ");
            for (int i = 0; i < fieldNames.length; ++i) {
                query.append(fieldNames[i]);
                if (i == fieldNames.length - 1) continue;
                query.append(", ");
            }
            query.append(" FROM ").append(tableName);
            if (conditions != null && conditions.length() > 0) {
                query.append(" WHERE ").append(conditions);
            }
            if ((orderBy = dbConf.getInputOrderBy()) != null && orderBy.length() > 0) {
                query.append(" ORDER BY ").append(orderBy);
            }
        } else {
            query.append(dbConf.getInputQuery());
        }
        try {
            DBInputFormat.DBInputSplit split = this.getSplit();
            if (split.getLength() > 0L) {
                String querystring = query.toString();
                query = new StringBuilder();
                query.append("SELECT * FROM (SELECT a.*,ROWNUM dbif_rno FROM ( ");
                query.append(querystring);
                query.append(" ) a WHERE rownum <= ").append(split.getEnd());
                query.append(" ) WHERE dbif_rno > ").append(split.getStart());
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return query.toString();
    }

    public static void setSessionTimeZone(Configuration conf, Connection conn) throws SQLException {
        Method method;
        try {
            method = conn.getClass().getMethod("setSessionTimeZone", String.class);
        }
        catch (Exception ex) {
            LOG.error("Could not find method setSessionTimeZone in " + conn.getClass().getName(), ex);
            throw new SQLException(ex);
        }
        String clientTimeZone = conf.get(SESSION_TIMEZONE_KEY, "GMT");
        try {
            method.setAccessible(true);
            method.invoke((Object)conn, clientTimeZone);
            LOG.info("Time zone has been set to " + clientTimeZone);
        }
        catch (Exception ex) {
            LOG.warn("Time zone " + clientTimeZone + " could not be set on Oracle database.");
            LOG.warn("Setting default time zone: GMT");
            try {
                method.invoke((Object)conn, "GMT");
            }
            catch (Exception ex2) {
                LOG.error("Could not set time zone for oracle connection", ex2);
                throw new SQLException(ex);
            }
        }
    }
}

