/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.fs.s3presto.shaded.org.apache.hadoop.mapreduce.lib.chain;

import java.io.IOException;
import org.apache.flink.fs.s3presto.shaded.org.apache.hadoop.classification.InterfaceAudience;
import org.apache.flink.fs.s3presto.shaded.org.apache.hadoop.classification.InterfaceStability;
import org.apache.flink.fs.s3presto.shaded.org.apache.hadoop.conf.Configuration;
import org.apache.flink.fs.s3presto.shaded.org.apache.hadoop.mapreduce.Job;
import org.apache.flink.fs.s3presto.shaded.org.apache.hadoop.mapreduce.Mapper;
import org.apache.flink.fs.s3presto.shaded.org.apache.hadoop.mapreduce.lib.chain.Chain;

@InterfaceAudience.Public
@InterfaceStability.Stable
public class ChainMapper<KEYIN, VALUEIN, KEYOUT, VALUEOUT>
extends Mapper<KEYIN, VALUEIN, KEYOUT, VALUEOUT> {
    private Chain chain;

    public static void addMapper(Job job, Class<? extends Mapper> klass, Class<?> inputKeyClass, Class<?> inputValueClass, Class<?> outputKeyClass, Class<?> outputValueClass, Configuration mapperConf) throws IOException {
        job.setMapperClass(ChainMapper.class);
        job.setMapOutputKeyClass(outputKeyClass);
        job.setMapOutputValueClass(outputValueClass);
        Chain.addMapper(true, job, klass, inputKeyClass, inputValueClass, outputKeyClass, outputValueClass, mapperConf);
    }

    @Override
    protected void setup(Mapper.Context context) {
        this.chain = new Chain(true);
        this.chain.setup(context.getConfiguration());
    }

    @Override
    public void run(Mapper.Context context) throws IOException, InterruptedException {
        this.setup(context);
        int numMappers = this.chain.getAllMappers().size();
        if (numMappers == 0) {
            return;
        }
        if (numMappers == 1) {
            this.chain.runMapper(context, 0);
        } else {
            Chain.ChainBlockingQueue<Chain.KeyValuePair<?, ?>> outputqueue = this.chain.createBlockingQueue();
            this.chain.addMapper(context, outputqueue, 0);
            for (int i = 1; i < numMappers - 1; ++i) {
                Chain.ChainBlockingQueue<Chain.KeyValuePair<?, ?>> inputqueue = outputqueue;
                outputqueue = this.chain.createBlockingQueue();
                this.chain.addMapper(inputqueue, outputqueue, context, i);
            }
            this.chain.addMapper(outputqueue, context, numMappers - 1);
        }
        this.chain.startAllThreads();
        this.chain.joinAllThreads();
    }
}

