/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.fs.s3presto.shaded.org.apache.hadoop.mapreduce.lib.aggregate;

import java.util.ArrayList;
import org.apache.flink.fs.s3presto.shaded.org.apache.hadoop.classification.InterfaceAudience;
import org.apache.flink.fs.s3presto.shaded.org.apache.hadoop.classification.InterfaceStability;
import org.apache.flink.fs.s3presto.shaded.org.apache.hadoop.mapreduce.lib.aggregate.ValueAggregator;

@InterfaceAudience.Public
@InterfaceStability.Stable
public class LongValueSum
implements ValueAggregator<String> {
    long sum = 0L;

    public LongValueSum() {
        this.reset();
    }

    @Override
    public void addNextValue(Object val) {
        this.sum += Long.parseLong(val.toString());
    }

    public void addNextValue(long val) {
        this.sum += val;
    }

    public long getSum() {
        return this.sum;
    }

    @Override
    public String getReport() {
        return "" + this.sum;
    }

    @Override
    public void reset() {
        this.sum = 0L;
    }

    @Override
    public ArrayList<String> getCombinerOutput() {
        ArrayList<String> retv = new ArrayList<String>(1);
        retv.add("" + this.sum);
        return retv;
    }
}

