/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.fs.s3presto.shaded.org.apache.hadoop.mapreduce.jobhistory;

import org.apache.flink.fs.s3presto.shaded.com.facebook.presto.hadoop.$internal.org.apache.avro.util.Utf8;
import org.apache.flink.fs.s3presto.shaded.org.apache.hadoop.classification.InterfaceAudience;
import org.apache.flink.fs.s3presto.shaded.org.apache.hadoop.classification.InterfaceStability;
import org.apache.flink.fs.s3presto.shaded.org.apache.hadoop.mapreduce.Counters;
import org.apache.flink.fs.s3presto.shaded.org.apache.hadoop.mapreduce.JobID;
import org.apache.flink.fs.s3presto.shaded.org.apache.hadoop.mapreduce.jobhistory.EventReader;
import org.apache.flink.fs.s3presto.shaded.org.apache.hadoop.mapreduce.jobhistory.EventType;
import org.apache.flink.fs.s3presto.shaded.org.apache.hadoop.mapreduce.jobhistory.EventWriter;
import org.apache.flink.fs.s3presto.shaded.org.apache.hadoop.mapreduce.jobhistory.HistoryEvent;
import org.apache.flink.fs.s3presto.shaded.org.apache.hadoop.mapreduce.jobhistory.JobFinished;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public class JobFinishedEvent
implements HistoryEvent {
    private JobFinished datum = null;
    private JobID jobId;
    private long finishTime;
    private int finishedMaps;
    private int finishedReduces;
    private int failedMaps;
    private int failedReduces;
    private Counters mapCounters;
    private Counters reduceCounters;
    private Counters totalCounters;

    public JobFinishedEvent(JobID id, long finishTime, int finishedMaps, int finishedReduces, int failedMaps, int failedReduces, Counters mapCounters, Counters reduceCounters, Counters totalCounters) {
        this.jobId = id;
        this.finishTime = finishTime;
        this.finishedMaps = finishedMaps;
        this.finishedReduces = finishedReduces;
        this.failedMaps = failedMaps;
        this.failedReduces = failedReduces;
        this.mapCounters = mapCounters;
        this.reduceCounters = reduceCounters;
        this.totalCounters = totalCounters;
    }

    JobFinishedEvent() {
    }

    @Override
    public Object getDatum() {
        if (this.datum == null) {
            this.datum = new JobFinished();
            this.datum.jobid = new Utf8(this.jobId.toString());
            this.datum.finishTime = this.finishTime;
            this.datum.finishedMaps = this.finishedMaps;
            this.datum.finishedReduces = this.finishedReduces;
            this.datum.failedMaps = this.failedMaps;
            this.datum.failedReduces = this.failedReduces;
            this.datum.mapCounters = EventWriter.toAvro(this.mapCounters, "MAP_COUNTERS");
            this.datum.reduceCounters = EventWriter.toAvro(this.reduceCounters, "REDUCE_COUNTERS");
            this.datum.totalCounters = EventWriter.toAvro(this.totalCounters, "TOTAL_COUNTERS");
        }
        return this.datum;
    }

    @Override
    public void setDatum(Object oDatum) {
        this.datum = (JobFinished)oDatum;
        this.jobId = JobID.forName(this.datum.jobid.toString());
        this.finishTime = this.datum.finishTime;
        this.finishedMaps = this.datum.finishedMaps;
        this.finishedReduces = this.datum.finishedReduces;
        this.failedMaps = this.datum.failedMaps;
        this.failedReduces = this.datum.failedReduces;
        this.mapCounters = EventReader.fromAvro(this.datum.mapCounters);
        this.reduceCounters = EventReader.fromAvro(this.datum.reduceCounters);
        this.totalCounters = EventReader.fromAvro(this.datum.totalCounters);
    }

    @Override
    public EventType getEventType() {
        return EventType.JOB_FINISHED;
    }

    public JobID getJobid() {
        return this.jobId;
    }

    public long getFinishTime() {
        return this.finishTime;
    }

    public int getFinishedMaps() {
        return this.finishedMaps;
    }

    public int getFinishedReduces() {
        return this.finishedReduces;
    }

    public int getFailedMaps() {
        return this.failedMaps;
    }

    public int getFailedReduces() {
        return this.failedReduces;
    }

    public Counters getTotalCounters() {
        return this.totalCounters;
    }

    public Counters getMapCounters() {
        return this.mapCounters;
    }

    public Counters getReduceCounters() {
        return this.reduceCounters;
    }
}

