/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.fs.s3presto.shaded.org.apache.hadoop.mapreduce;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.apache.flink.fs.s3presto.shaded.org.apache.hadoop.classification.InterfaceAudience;
import org.apache.flink.fs.s3presto.shaded.org.apache.hadoop.classification.InterfaceStability;
import org.apache.flink.fs.s3presto.shaded.org.apache.hadoop.io.Writable;
import org.apache.flink.fs.s3presto.shaded.org.apache.hadoop.io.WritableUtils;
import org.apache.flink.fs.s3presto.shaded.org.apache.hadoop.mapreduce.TaskAttemptID;

@InterfaceAudience.Public
@InterfaceStability.Evolving
public class TaskCompletionEvent
implements Writable {
    private int eventId;
    private String taskTrackerHttp;
    private int taskRunTime;
    private TaskAttemptID taskId;
    Status status;
    boolean isMap = false;
    private int idWithinJob;
    public static final TaskCompletionEvent[] EMPTY_ARRAY = new TaskCompletionEvent[0];

    public TaskCompletionEvent() {
        this.taskId = new TaskAttemptID();
    }

    public TaskCompletionEvent(int eventId, TaskAttemptID taskId, int idWithinJob, boolean isMap, Status status, String taskTrackerHttp) {
        this.taskId = taskId;
        this.idWithinJob = idWithinJob;
        this.isMap = isMap;
        this.eventId = eventId;
        this.status = status;
        this.taskTrackerHttp = taskTrackerHttp;
    }

    public int getEventId() {
        return this.eventId;
    }

    public TaskAttemptID getTaskAttemptId() {
        return this.taskId;
    }

    public Status getStatus() {
        return this.status;
    }

    public String getTaskTrackerHttp() {
        return this.taskTrackerHttp;
    }

    public int getTaskRunTime() {
        return this.taskRunTime;
    }

    protected void setTaskRunTime(int taskCompletionTime) {
        this.taskRunTime = taskCompletionTime;
    }

    protected void setEventId(int eventId) {
        this.eventId = eventId;
    }

    protected void setTaskAttemptId(TaskAttemptID taskId) {
        this.taskId = taskId;
    }

    protected void setTaskStatus(Status status) {
        this.status = status;
    }

    protected void setTaskTrackerHttp(String taskTrackerHttp) {
        this.taskTrackerHttp = taskTrackerHttp;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append("Task Id : ");
        buf.append(this.taskId);
        buf.append(", Status : ");
        buf.append(this.status.name());
        return buf.toString();
    }

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (o.getClass().equals(this.getClass())) {
            TaskCompletionEvent event = (TaskCompletionEvent)o;
            return this.isMap == event.isMapTask() && this.eventId == event.getEventId() && this.idWithinJob == event.idWithinJob() && this.status.equals((Object)event.getStatus()) && this.taskId.equals(event.getTaskAttemptId()) && this.taskRunTime == event.getTaskRunTime() && this.taskTrackerHttp.equals(event.getTaskTrackerHttp());
        }
        return false;
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    public boolean isMapTask() {
        return this.isMap;
    }

    public int idWithinJob() {
        return this.idWithinJob;
    }

    @Override
    public void write(DataOutput out) throws IOException {
        this.taskId.write(out);
        WritableUtils.writeVInt(out, this.idWithinJob);
        out.writeBoolean(this.isMap);
        WritableUtils.writeEnum(out, this.status);
        WritableUtils.writeString(out, this.taskTrackerHttp);
        WritableUtils.writeVInt(out, this.taskRunTime);
        WritableUtils.writeVInt(out, this.eventId);
    }

    @Override
    public void readFields(DataInput in) throws IOException {
        this.taskId.readFields(in);
        this.idWithinJob = WritableUtils.readVInt(in);
        this.isMap = in.readBoolean();
        this.status = WritableUtils.readEnum(in, Status.class);
        this.taskTrackerHttp = WritableUtils.readString(in);
        this.taskRunTime = WritableUtils.readVInt(in);
        this.eventId = WritableUtils.readVInt(in);
    }

    @InterfaceAudience.Public
    @InterfaceStability.Evolving
    public static enum Status {
        FAILED,
        KILLED,
        SUCCEEDED,
        OBSOLETE,
        TIPFAILED;

    }
}

