/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.fs.s3presto.shaded.org.apache.hadoop.mapreduce;

import java.util.HashMap;
import java.util.Map;
import org.apache.flink.fs.s3presto.shaded.org.apache.hadoop.classification.InterfaceAudience;
import org.apache.flink.fs.s3presto.shaded.org.apache.hadoop.classification.InterfaceStability;

@InterfaceAudience.Public
@InterfaceStability.Evolving
public enum QueueState {
    STOPPED("stopped"),
    RUNNING("running"),
    UNDEFINED("undefined");

    private final String stateName;
    private static Map<String, QueueState> enumMap;

    private QueueState(String stateName) {
        this.stateName = stateName;
    }

    public String getStateName() {
        return this.stateName;
    }

    public static QueueState getState(String state) {
        QueueState qState = enumMap.get(state);
        if (qState == null) {
            return UNDEFINED;
        }
        return qState;
    }

    public String toString() {
        return this.stateName;
    }

    static {
        enumMap = new HashMap<String, QueueState>();
        for (QueueState state : QueueState.values()) {
            enumMap.put(state.getStateName(), state);
        }
    }
}

