/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.fs.s3presto.shaded.org.apache.hadoop.mapreduce;

import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import org.apache.flink.fs.s3presto.shaded.org.apache.hadoop.conf.Configuration;
import org.apache.flink.fs.s3presto.shaded.org.apache.hadoop.mapreduce.InputSplit;
import org.apache.flink.fs.s3presto.shaded.org.apache.hadoop.mapreduce.JobContext;
import org.apache.flink.fs.s3presto.shaded.org.apache.hadoop.mapreduce.JobID;
import org.apache.flink.fs.s3presto.shaded.org.apache.hadoop.mapreduce.MapContext;
import org.apache.flink.fs.s3presto.shaded.org.apache.hadoop.mapreduce.Mapper;
import org.apache.flink.fs.s3presto.shaded.org.apache.hadoop.mapreduce.OutputCommitter;
import org.apache.flink.fs.s3presto.shaded.org.apache.hadoop.mapreduce.RecordReader;
import org.apache.flink.fs.s3presto.shaded.org.apache.hadoop.mapreduce.RecordWriter;
import org.apache.flink.fs.s3presto.shaded.org.apache.hadoop.mapreduce.ReduceContext;
import org.apache.flink.fs.s3presto.shaded.org.apache.hadoop.mapreduce.StatusReporter;
import org.apache.flink.fs.s3presto.shaded.org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.flink.fs.s3presto.shaded.org.apache.hadoop.mapreduce.TaskAttemptID;

public class ContextFactory {
    private static final Constructor<?> JOB_CONTEXT_CONSTRUCTOR;
    private static final Constructor<?> TASK_CONTEXT_CONSTRUCTOR;
    private static final Constructor<?> MAP_CONTEXT_CONSTRUCTOR;
    private static final Constructor<?> MAP_CONTEXT_IMPL_CONSTRUCTOR;
    private static final boolean useV21;
    private static final Field REPORTER_FIELD;
    private static final Field READER_FIELD;
    private static final Field WRITER_FIELD;
    private static final Field OUTER_MAP_FIELD;
    private static final Field WRAPPED_CONTEXT_FIELD;

    public static JobContext cloneContext(JobContext original, Configuration conf) throws IOException, InterruptedException {
        try {
            if (original instanceof MapContext) {
                return ContextFactory.cloneMapContext((Mapper.Context)original, conf, null, null);
            }
            if (original instanceof ReduceContext) {
                throw new IllegalArgumentException("can't clone ReduceContext");
            }
            if (original instanceof TaskAttemptContext) {
                TaskAttemptContext spec = (TaskAttemptContext)original;
                return (JobContext)TASK_CONTEXT_CONSTRUCTOR.newInstance(conf, spec.getTaskAttemptID());
            }
            return (JobContext)JOB_CONTEXT_CONSTRUCTOR.newInstance(conf, original.getJobID());
        }
        catch (InstantiationException e) {
            throw new IllegalArgumentException("Can't clone object", e);
        }
        catch (IllegalAccessException e) {
            throw new IllegalArgumentException("Can't clone object", e);
        }
        catch (InvocationTargetException e) {
            throw new IllegalArgumentException("Can't clone object", e);
        }
    }

    public static <K1, V1, K2, V2> Mapper.Context cloneMapContext(MapContext<K1, V1, K2, V2> context, Configuration conf, RecordReader<K1, V1> reader, RecordWriter<K2, V2> writer) throws IOException, InterruptedException {
        try {
            Object outer = OUTER_MAP_FIELD.get(context);
            if ("org.apache.flink.fs.s3presto.shaded.org.apache.hadoop.mapreduce.lib.map.WrappedMapper$Context".equals(context.getClass().getName())) {
                context = (MapContext)WRAPPED_CONTEXT_FIELD.get(context);
            }
            if (reader == null) {
                reader = (RecordReader)READER_FIELD.get(context);
            }
            if (writer == null) {
                writer = (RecordWriter)WRITER_FIELD.get(context);
            }
            if (useV21) {
                Object basis = MAP_CONTEXT_IMPL_CONSTRUCTOR.newInstance(conf, context.getTaskAttemptID(), reader, writer, context.getOutputCommitter(), REPORTER_FIELD.get(context), context.getInputSplit());
                return (Mapper.Context)MAP_CONTEXT_CONSTRUCTOR.newInstance(outer, basis);
            }
            return (Mapper.Context)MAP_CONTEXT_CONSTRUCTOR.newInstance(outer, conf, context.getTaskAttemptID(), reader, writer, context.getOutputCommitter(), REPORTER_FIELD.get(context), context.getInputSplit());
        }
        catch (IllegalAccessException e) {
            throw new IllegalArgumentException("Can't access field", e);
        }
        catch (InstantiationException e) {
            throw new IllegalArgumentException("Can't create object", e);
        }
        catch (InvocationTargetException e) {
            throw new IllegalArgumentException("Can't invoke constructor", e);
        }
    }

    static {
        Class<?> innerMapContextCls;
        Class<?> mapCls;
        Class<?> mapContextCls;
        Class<?> taskIOContextCls;
        Class<?> taskContextCls;
        Class<?> jobContextCls;
        boolean v21 = true;
        String PACKAGE = "org.apache.flink.fs.s3presto.shaded.org.apache.hadoop.mapreduce";
        try {
            Class.forName("org.apache.flink.fs.s3presto.shaded.org.apache.hadoop.mapreduce.task.JobContextImpl");
        }
        catch (ClassNotFoundException cnfe) {
            v21 = false;
        }
        useV21 = v21;
        try {
            if (v21) {
                jobContextCls = Class.forName("org.apache.flink.fs.s3presto.shaded.org.apache.hadoop.mapreduce.task.JobContextImpl");
                taskContextCls = Class.forName("org.apache.flink.fs.s3presto.shaded.org.apache.hadoop.mapreduce.task.TaskAttemptContextImpl");
                taskIOContextCls = Class.forName("org.apache.flink.fs.s3presto.shaded.org.apache.hadoop.mapreduce.task.TaskInputOutputContextImpl");
                mapContextCls = Class.forName("org.apache.flink.fs.s3presto.shaded.org.apache.hadoop.mapreduce.task.MapContextImpl");
                mapCls = Class.forName("org.apache.flink.fs.s3presto.shaded.org.apache.hadoop.mapreduce.lib.map.WrappedMapper");
                innerMapContextCls = Class.forName("org.apache.flink.fs.s3presto.shaded.org.apache.hadoop.mapreduce.lib.map.WrappedMapper$Context");
            } else {
                jobContextCls = Class.forName("org.apache.flink.fs.s3presto.shaded.org.apache.hadoop.mapreduce.JobContext");
                taskContextCls = Class.forName("org.apache.flink.fs.s3presto.shaded.org.apache.hadoop.mapreduce.TaskAttemptContext");
                taskIOContextCls = Class.forName("org.apache.flink.fs.s3presto.shaded.org.apache.hadoop.mapreduce.TaskInputOutputContext");
                mapContextCls = Class.forName("org.apache.flink.fs.s3presto.shaded.org.apache.hadoop.mapreduce.MapContext");
                mapCls = Class.forName("org.apache.flink.fs.s3presto.shaded.org.apache.hadoop.mapreduce.Mapper");
                innerMapContextCls = Class.forName("org.apache.flink.fs.s3presto.shaded.org.apache.hadoop.mapreduce.Mapper$Context");
            }
        }
        catch (ClassNotFoundException e) {
            throw new IllegalArgumentException("Can't find class", e);
        }
        try {
            JOB_CONTEXT_CONSTRUCTOR = jobContextCls.getConstructor(Configuration.class, JobID.class);
            JOB_CONTEXT_CONSTRUCTOR.setAccessible(true);
            TASK_CONTEXT_CONSTRUCTOR = taskContextCls.getConstructor(Configuration.class, TaskAttemptID.class);
            TASK_CONTEXT_CONSTRUCTOR.setAccessible(true);
            if (useV21) {
                MAP_CONTEXT_CONSTRUCTOR = innerMapContextCls.getConstructor(mapCls, MapContext.class);
                MAP_CONTEXT_IMPL_CONSTRUCTOR = mapContextCls.getDeclaredConstructor(Configuration.class, TaskAttemptID.class, RecordReader.class, RecordWriter.class, OutputCommitter.class, StatusReporter.class, InputSplit.class);
                MAP_CONTEXT_IMPL_CONSTRUCTOR.setAccessible(true);
                WRAPPED_CONTEXT_FIELD = innerMapContextCls.getDeclaredField("mapContext");
                WRAPPED_CONTEXT_FIELD.setAccessible(true);
            } else {
                MAP_CONTEXT_CONSTRUCTOR = innerMapContextCls.getConstructor(mapCls, Configuration.class, TaskAttemptID.class, RecordReader.class, RecordWriter.class, OutputCommitter.class, StatusReporter.class, InputSplit.class);
                MAP_CONTEXT_IMPL_CONSTRUCTOR = null;
                WRAPPED_CONTEXT_FIELD = null;
            }
            MAP_CONTEXT_CONSTRUCTOR.setAccessible(true);
            REPORTER_FIELD = taskContextCls.getDeclaredField("reporter");
            REPORTER_FIELD.setAccessible(true);
            READER_FIELD = mapContextCls.getDeclaredField("reader");
            READER_FIELD.setAccessible(true);
            WRITER_FIELD = taskIOContextCls.getDeclaredField("output");
            WRITER_FIELD.setAccessible(true);
            OUTER_MAP_FIELD = innerMapContextCls.getDeclaredField("this$0");
            OUTER_MAP_FIELD.setAccessible(true);
        }
        catch (SecurityException e) {
            throw new IllegalArgumentException("Can't run constructor ", e);
        }
        catch (NoSuchMethodException e) {
            throw new IllegalArgumentException("Can't find constructor ", e);
        }
        catch (NoSuchFieldException e) {
            throw new IllegalArgumentException("Can't find field ", e);
        }
    }
}

