/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.fs.s3presto.shaded.org.apache.hadoop.mapred.pipes;

import org.apache.flink.fs.s3presto.shaded.org.apache.hadoop.io.Writable;
import org.apache.flink.fs.s3presto.shaded.org.apache.hadoop.io.WritableComparable;
import org.apache.flink.fs.s3presto.shaded.org.apache.hadoop.mapred.JobConf;
import org.apache.flink.fs.s3presto.shaded.org.apache.hadoop.mapred.Partitioner;
import org.apache.flink.fs.s3presto.shaded.org.apache.hadoop.mapred.pipes.Submitter;
import org.apache.flink.fs.s3presto.shaded.org.apache.hadoop.util.ReflectionUtils;

class PipesPartitioner<K extends WritableComparable, V extends Writable>
implements Partitioner<K, V> {
    private static ThreadLocal<Integer> cache = new ThreadLocal();
    private Partitioner<K, V> part = null;

    PipesPartitioner() {
    }

    @Override
    public void configure(JobConf conf) {
        this.part = ReflectionUtils.newInstance(Submitter.getJavaPartitioner(conf), conf);
    }

    static void setNextPartition(int newValue) {
        cache.set(newValue);
    }

    @Override
    public int getPartition(K key, V value, int numPartitions) {
        Integer result = cache.get();
        if (result == null) {
            return this.part.getPartition(key, value, numPartitions);
        }
        return result;
    }
}

