/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.fs.s3presto.shaded.org.apache.hadoop.mapred.lib.aggregate;

import java.util.Map;
import org.apache.flink.fs.s3presto.shaded.org.apache.hadoop.classification.InterfaceAudience;
import org.apache.flink.fs.s3presto.shaded.org.apache.hadoop.classification.InterfaceStability;
import org.apache.flink.fs.s3presto.shaded.org.apache.hadoop.io.Text;
import org.apache.flink.fs.s3presto.shaded.org.apache.hadoop.mapred.JobConf;
import org.apache.flink.fs.s3presto.shaded.org.apache.hadoop.mapred.lib.aggregate.DoubleValueSum;
import org.apache.flink.fs.s3presto.shaded.org.apache.hadoop.mapred.lib.aggregate.LongValueMax;
import org.apache.flink.fs.s3presto.shaded.org.apache.hadoop.mapred.lib.aggregate.LongValueMin;
import org.apache.flink.fs.s3presto.shaded.org.apache.hadoop.mapred.lib.aggregate.LongValueSum;
import org.apache.flink.fs.s3presto.shaded.org.apache.hadoop.mapred.lib.aggregate.StringValueMax;
import org.apache.flink.fs.s3presto.shaded.org.apache.hadoop.mapred.lib.aggregate.StringValueMin;
import org.apache.flink.fs.s3presto.shaded.org.apache.hadoop.mapred.lib.aggregate.UniqValueCount;
import org.apache.flink.fs.s3presto.shaded.org.apache.hadoop.mapred.lib.aggregate.ValueAggregator;
import org.apache.flink.fs.s3presto.shaded.org.apache.hadoop.mapred.lib.aggregate.ValueAggregatorDescriptor;
import org.apache.flink.fs.s3presto.shaded.org.apache.hadoop.mapred.lib.aggregate.ValueHistogram;

@InterfaceAudience.Public
@InterfaceStability.Stable
public class ValueAggregatorBaseDescriptor
extends org.apache.flink.fs.s3presto.shaded.org.apache.hadoop.mapreduce.lib.aggregate.ValueAggregatorBaseDescriptor
implements ValueAggregatorDescriptor {
    public static final String UNIQ_VALUE_COUNT = "UniqValueCount";
    public static final String LONG_VALUE_SUM = "LongValueSum";
    public static final String DOUBLE_VALUE_SUM = "DoubleValueSum";
    public static final String VALUE_HISTOGRAM = "ValueHistogram";
    public static final String LONG_VALUE_MAX = "LongValueMax";
    public static final String LONG_VALUE_MIN = "LongValueMin";
    public static final String STRING_VALUE_MAX = "StringValueMax";
    public static final String STRING_VALUE_MIN = "StringValueMin";
    private static long maxNumItems = Long.MAX_VALUE;

    public static Map.Entry<Text, Text> generateEntry(String type, String id, Text val) {
        return org.apache.flink.fs.s3presto.shaded.org.apache.hadoop.mapreduce.lib.aggregate.ValueAggregatorBaseDescriptor.generateEntry(type, id, val);
    }

    public static ValueAggregator generateValueAggregator(String type) {
        ValueAggregator<String> retv = null;
        if (type.compareToIgnoreCase(LONG_VALUE_SUM) == 0) {
            retv = new LongValueSum();
        }
        if (type.compareToIgnoreCase(LONG_VALUE_MAX) == 0) {
            retv = new LongValueMax();
        } else if (type.compareToIgnoreCase(LONG_VALUE_MIN) == 0) {
            retv = new LongValueMin();
        } else if (type.compareToIgnoreCase(STRING_VALUE_MAX) == 0) {
            retv = new StringValueMax();
        } else if (type.compareToIgnoreCase(STRING_VALUE_MIN) == 0) {
            retv = new StringValueMin();
        } else if (type.compareToIgnoreCase(DOUBLE_VALUE_SUM) == 0) {
            retv = new DoubleValueSum();
        } else if (type.compareToIgnoreCase(UNIQ_VALUE_COUNT) == 0) {
            retv = new UniqValueCount(maxNumItems);
        } else if (type.compareToIgnoreCase(VALUE_HISTOGRAM) == 0) {
            retv = new ValueHistogram();
        }
        return retv;
    }

    @Override
    public void configure(JobConf job) {
        super.configure(job);
        maxNumItems = job.getLong("aggregate.max.num.unique.values", Long.MAX_VALUE);
    }
}

