/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.fs.s3presto.shaded.org.apache.hadoop.mapred.lib;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.apache.flink.fs.s3presto.shaded.org.apache.hadoop.conf.Configurable;
import org.apache.flink.fs.s3presto.shaded.org.apache.hadoop.conf.Configuration;
import org.apache.flink.fs.s3presto.shaded.org.apache.hadoop.io.Text;
import org.apache.flink.fs.s3presto.shaded.org.apache.hadoop.mapred.InputFormat;
import org.apache.flink.fs.s3presto.shaded.org.apache.hadoop.mapred.InputSplit;
import org.apache.flink.fs.s3presto.shaded.org.apache.hadoop.mapred.Mapper;
import org.apache.flink.fs.s3presto.shaded.org.apache.hadoop.util.ReflectionUtils;
import org.apache.flink.fs.s3presto.shaded.org.apache.hadoop.util.StringInterner;

class TaggedInputSplit
implements Configurable,
InputSplit {
    private Class<? extends InputSplit> inputSplitClass;
    private InputSplit inputSplit;
    private Class<? extends InputFormat> inputFormatClass;
    private Class<? extends Mapper> mapperClass;
    private Configuration conf;

    public TaggedInputSplit() {
    }

    public TaggedInputSplit(InputSplit inputSplit, Configuration conf, Class<? extends InputFormat> inputFormatClass, Class<? extends Mapper> mapperClass) {
        this.inputSplitClass = inputSplit.getClass();
        this.inputSplit = inputSplit;
        this.conf = conf;
        this.inputFormatClass = inputFormatClass;
        this.mapperClass = mapperClass;
    }

    public InputSplit getInputSplit() {
        return this.inputSplit;
    }

    public Class<? extends InputFormat> getInputFormatClass() {
        return this.inputFormatClass;
    }

    public Class<? extends Mapper> getMapperClass() {
        return this.mapperClass;
    }

    @Override
    public long getLength() throws IOException {
        return this.inputSplit.getLength();
    }

    @Override
    public String[] getLocations() throws IOException {
        return this.inputSplit.getLocations();
    }

    @Override
    public void readFields(DataInput in) throws IOException {
        this.inputSplitClass = this.readClass(in);
        this.inputSplit = ReflectionUtils.newInstance(this.inputSplitClass, this.conf);
        this.inputSplit.readFields(in);
        this.inputFormatClass = this.readClass(in);
        this.mapperClass = this.readClass(in);
    }

    private Class<?> readClass(DataInput in) throws IOException {
        String className = StringInterner.weakIntern(Text.readString(in));
        try {
            return this.conf.getClassByName(className);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException("readObject can't find class", e);
        }
    }

    @Override
    public void write(DataOutput out) throws IOException {
        Text.writeString(out, this.inputSplitClass.getName());
        this.inputSplit.write(out);
        Text.writeString(out, this.inputFormatClass.getName());
        Text.writeString(out, this.mapperClass.getName());
    }

    @Override
    public Configuration getConf() {
        return this.conf;
    }

    @Override
    public void setConf(Configuration conf) {
        this.conf = conf;
    }

    public String toString() {
        return this.inputSplit.toString();
    }
}

