/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.fs.s3presto.shaded.org.apache.hadoop.mapred;

import java.io.Flushable;
import java.util.LinkedList;
import java.util.Queue;
import org.apache.flink.fs.s3presto.shaded.com.facebook.presto.hadoop.$internal.org.apache.log4j.FileAppender;
import org.apache.flink.fs.s3presto.shaded.com.facebook.presto.hadoop.$internal.org.apache.log4j.spi.LoggingEvent;
import org.apache.flink.fs.s3presto.shaded.org.apache.hadoop.classification.InterfaceStability;
import org.apache.flink.fs.s3presto.shaded.org.apache.hadoop.mapred.TaskAttemptID;
import org.apache.flink.fs.s3presto.shaded.org.apache.hadoop.mapred.TaskLog;

@InterfaceStability.Unstable
public class TaskLogAppender
extends FileAppender
implements Flushable {
    private String taskId;
    private Integer maxEvents;
    private Queue<LoggingEvent> tail = null;
    private Boolean isCleanup;
    static final String ISCLEANUP_PROPERTY = "hadoop.tasklog.iscleanup";
    static final String LOGSIZE_PROPERTY = "hadoop.tasklog.totalLogFileSize";
    static final String TASKID_PROPERTY = "hadoop.tasklog.taskid";
    private static final int EVENT_SIZE = 100;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void activateOptions() {
        TaskLogAppender taskLogAppender = this;
        synchronized (taskLogAppender) {
            this.setOptionsFromSystemProperties();
            if (this.maxEvents > 0) {
                this.tail = new LinkedList<LoggingEvent>();
            }
            this.setFile(TaskLog.getTaskLogFile(TaskAttemptID.forName(this.taskId), this.isCleanup, TaskLog.LogName.SYSLOG).toString());
            this.setAppend(true);
            super.activateOptions();
        }
    }

    private synchronized void setOptionsFromSystemProperties() {
        String propValue;
        if (this.isCleanup == null) {
            propValue = System.getProperty(ISCLEANUP_PROPERTY, "false");
            this.isCleanup = Boolean.valueOf(propValue);
        }
        if (this.taskId == null) {
            this.taskId = System.getProperty(TASKID_PROPERTY);
        }
        if (this.maxEvents == null) {
            propValue = System.getProperty(LOGSIZE_PROPERTY, "0");
            this.setTotalLogFileSize(Long.parseLong(propValue));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void append(LoggingEvent event) {
        TaskLogAppender taskLogAppender = this;
        synchronized (taskLogAppender) {
            if (this.tail == null) {
                super.append(event);
            } else {
                if (this.tail.size() >= this.maxEvents) {
                    this.tail.remove();
                }
                this.tail.add(event);
            }
        }
    }

    @Override
    public void flush() {
        if (this.qw != null) {
            this.qw.flush();
        }
    }

    public synchronized void close() {
        if (this.tail != null) {
            for (LoggingEvent event : this.tail) {
                super.append(event);
            }
        }
        super.close();
    }

    public synchronized String getTaskId() {
        return this.taskId;
    }

    public synchronized void setTaskId(String taskId) {
        this.taskId = taskId;
    }

    public synchronized long getTotalLogFileSize() {
        return this.maxEvents * 100;
    }

    public synchronized void setTotalLogFileSize(long logSize) {
        this.maxEvents = (int)logSize / 100;
    }

    public synchronized void setIsCleanup(boolean isCleanup) {
        this.isCleanup = isCleanup;
    }

    public synchronized boolean getIsCleanup() {
        return this.isCleanup;
    }
}

