/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.fs.s3presto.shaded.org.apache.hadoop.mapred;

import java.io.IOException;
import org.apache.flink.fs.s3presto.shaded.org.apache.hadoop.classification.InterfaceAudience;
import org.apache.flink.fs.s3presto.shaded.org.apache.hadoop.classification.InterfaceStability;
import org.apache.flink.fs.s3presto.shaded.org.apache.hadoop.conf.Configuration;
import org.apache.flink.fs.s3presto.shaded.org.apache.hadoop.io.LongWritable;
import org.apache.flink.fs.s3presto.shaded.org.apache.hadoop.io.Text;
import org.apache.flink.fs.s3presto.shaded.org.apache.hadoop.mapred.FileSplit;
import org.apache.flink.fs.s3presto.shaded.org.apache.hadoop.mapred.LineRecordReader;
import org.apache.flink.fs.s3presto.shaded.org.apache.hadoop.mapred.RecordReader;

@InterfaceAudience.Public
@InterfaceStability.Stable
public class KeyValueLineRecordReader
implements RecordReader<Text, Text> {
    private final LineRecordReader lineRecordReader;
    private byte separator = (byte)9;
    private LongWritable dummyKey;
    private Text innerValue;

    public Class getKeyClass() {
        return Text.class;
    }

    @Override
    public Text createKey() {
        return new Text();
    }

    @Override
    public Text createValue() {
        return new Text();
    }

    public KeyValueLineRecordReader(Configuration job, FileSplit split) throws IOException {
        this.lineRecordReader = new LineRecordReader(job, split);
        this.dummyKey = this.lineRecordReader.createKey();
        this.innerValue = this.lineRecordReader.createValue();
        String sepStr = job.get("mapreduce.input.keyvaluelinerecordreader.key.value.separator", "\t");
        this.separator = (byte)sepStr.charAt(0);
    }

    public static int findSeparator(byte[] utf, int start, int length, byte sep) {
        return org.apache.flink.fs.s3presto.shaded.org.apache.hadoop.mapreduce.lib.input.KeyValueLineRecordReader.findSeparator(utf, start, length, sep);
    }

    @Override
    public synchronized boolean next(Text key, Text value) throws IOException {
        byte[] line = null;
        int lineLen = -1;
        if (!this.lineRecordReader.next(this.dummyKey, this.innerValue)) {
            return false;
        }
        line = this.innerValue.getBytes();
        lineLen = this.innerValue.getLength();
        if (line == null) {
            return false;
        }
        int pos = KeyValueLineRecordReader.findSeparator(line, 0, lineLen, this.separator);
        org.apache.flink.fs.s3presto.shaded.org.apache.hadoop.mapreduce.lib.input.KeyValueLineRecordReader.setKeyValue(key, value, line, lineLen, pos);
        return true;
    }

    @Override
    public float getProgress() throws IOException {
        return this.lineRecordReader.getProgress();
    }

    @Override
    public synchronized long getPos() throws IOException {
        return this.lineRecordReader.getPos();
    }

    @Override
    public synchronized void close() throws IOException {
        this.lineRecordReader.close();
    }
}

