/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.fs.s3presto.shaded.org.apache.hadoop.mapred;

import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import org.apache.flink.fs.s3presto.shaded.org.apache.hadoop.classification.InterfaceAudience;
import org.apache.flink.fs.s3presto.shaded.org.apache.hadoop.classification.InterfaceStability;
import org.apache.flink.fs.s3presto.shaded.org.apache.hadoop.mapreduce.JobStatus;
import org.apache.flink.fs.s3presto.shaded.org.apache.hadoop.mapreduce.QueueInfo;
import org.apache.flink.fs.s3presto.shaded.org.apache.hadoop.mapreduce.QueueState;

@InterfaceAudience.Public
@InterfaceStability.Stable
public class JobQueueInfo
extends QueueInfo {
    public JobQueueInfo() {
    }

    public JobQueueInfo(String queueName, String schedulingInfo) {
        super(queueName, schedulingInfo);
    }

    JobQueueInfo(QueueInfo queue) {
        this(queue.getQueueName(), queue.getSchedulingInfo());
        this.setQueueState(queue.getState().getStateName());
        this.setQueueChildren(queue.getQueueChildren());
        this.setProperties(queue.getProperties());
        this.setJobStatuses(queue.getJobStatuses());
    }

    @Override
    @InterfaceAudience.Private
    public void setQueueName(String queueName) {
        super.setQueueName(queueName);
    }

    @Override
    @InterfaceAudience.Private
    public void setSchedulingInfo(String schedulingInfo) {
        super.setSchedulingInfo(schedulingInfo);
    }

    @InterfaceAudience.Private
    public void setQueueState(String state) {
        super.setState(QueueState.getState(state));
    }

    @Deprecated
    public String getQueueState() {
        return super.getState().toString();
    }

    @InterfaceAudience.Private
    public void setChildren(List<JobQueueInfo> children) {
        ArrayList<QueueInfo> list = new ArrayList<QueueInfo>();
        for (JobQueueInfo q : children) {
            list.add(q);
        }
        super.setQueueChildren(list);
    }

    public List<JobQueueInfo> getChildren() {
        ArrayList<JobQueueInfo> list = new ArrayList<JobQueueInfo>();
        for (QueueInfo q : super.getQueueChildren()) {
            list.add((JobQueueInfo)q);
        }
        return list;
    }

    @Override
    @InterfaceAudience.Private
    public void setProperties(Properties props) {
        super.setProperties(props);
    }

    void addChild(JobQueueInfo child) {
        List<JobQueueInfo> children = this.getChildren();
        children.add(child);
        this.setChildren(children);
    }

    void removeChild(JobQueueInfo child) {
        List<JobQueueInfo> children = this.getChildren();
        children.remove(child);
        this.setChildren(children);
    }

    @Override
    @InterfaceAudience.Private
    public void setJobStatuses(JobStatus[] stats) {
        super.setJobStatuses(stats);
    }
}

