/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.fs.s3presto.shaded.org.apache.hadoop.mapred;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.net.URL;
import org.apache.flink.fs.s3presto.shaded.org.apache.hadoop.classification.InterfaceAudience;
import org.apache.flink.fs.s3presto.shaded.org.apache.hadoop.classification.InterfaceStability;
import org.apache.flink.fs.s3presto.shaded.org.apache.hadoop.io.Text;
import org.apache.flink.fs.s3presto.shaded.org.apache.hadoop.io.Writable;
import org.apache.flink.fs.s3presto.shaded.org.apache.hadoop.io.WritableFactories;
import org.apache.flink.fs.s3presto.shaded.org.apache.hadoop.io.WritableFactory;
import org.apache.flink.fs.s3presto.shaded.org.apache.hadoop.mapreduce.JobID;
import org.apache.flink.fs.s3presto.shaded.org.apache.hadoop.util.StringInterner;

@InterfaceAudience.LimitedPrivate(value={"MapReduce"})
@InterfaceStability.Unstable
public class JobProfile
implements Writable {
    String user;
    final org.apache.flink.fs.s3presto.shaded.org.apache.hadoop.mapred.JobID jobid;
    String jobFile;
    String url;
    String name;
    String queueName;

    public JobProfile() {
        this.jobid = new org.apache.flink.fs.s3presto.shaded.org.apache.hadoop.mapred.JobID();
    }

    public JobProfile(String user, JobID jobid, String jobFile, String url, String name) {
        this(user, jobid, jobFile, url, name, "default");
    }

    public JobProfile(String user, JobID jobid, String jobFile, String url, String name, String queueName) {
        this.user = user;
        this.jobid = org.apache.flink.fs.s3presto.shaded.org.apache.hadoop.mapred.JobID.downgrade(jobid);
        this.jobFile = jobFile;
        this.url = url;
        this.name = name;
        this.queueName = queueName;
    }

    @Deprecated
    public JobProfile(String user, String jobid, String jobFile, String url, String name) {
        this(user, org.apache.flink.fs.s3presto.shaded.org.apache.hadoop.mapred.JobID.forName(jobid), jobFile, url, name);
    }

    public String getUser() {
        return this.user;
    }

    public org.apache.flink.fs.s3presto.shaded.org.apache.hadoop.mapred.JobID getJobID() {
        return this.jobid;
    }

    @Deprecated
    public String getJobId() {
        return this.jobid.toString();
    }

    public String getJobFile() {
        return this.jobFile;
    }

    public URL getURL() {
        try {
            return new URL(this.url);
        }
        catch (IOException ie) {
            return null;
        }
    }

    public String getJobName() {
        return this.name;
    }

    public String getQueueName() {
        return this.queueName;
    }

    @Override
    public void write(DataOutput out) throws IOException {
        this.jobid.write(out);
        Text.writeString(out, this.jobFile);
        Text.writeString(out, this.url);
        Text.writeString(out, this.user);
        Text.writeString(out, this.name);
        Text.writeString(out, this.queueName);
    }

    @Override
    public void readFields(DataInput in) throws IOException {
        this.jobid.readFields(in);
        this.jobFile = StringInterner.weakIntern(Text.readString(in));
        this.url = StringInterner.weakIntern(Text.readString(in));
        this.user = StringInterner.weakIntern(Text.readString(in));
        this.name = StringInterner.weakIntern(Text.readString(in));
        this.queueName = StringInterner.weakIntern(Text.readString(in));
    }

    static {
        WritableFactories.setFactory(JobProfile.class, new WritableFactory(){

            @Override
            public Writable newInstance() {
                return new JobProfile();
            }
        });
    }
}

