/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.fs.s3presto.shaded.org.apache.hadoop.io.compress.zlib;

import java.io.IOException;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import org.apache.flink.fs.s3presto.shaded.com.facebook.presto.hadoop.$internal.org.apache.commons.logging.Log;
import org.apache.flink.fs.s3presto.shaded.com.facebook.presto.hadoop.$internal.org.apache.commons.logging.LogFactory;
import org.apache.flink.fs.s3presto.shaded.org.apache.hadoop.conf.Configuration;
import org.apache.flink.fs.s3presto.shaded.org.apache.hadoop.io.compress.Compressor;
import org.apache.flink.fs.s3presto.shaded.org.apache.hadoop.io.compress.zlib.ZlibFactory;
import org.apache.flink.fs.s3presto.shaded.org.apache.hadoop.util.NativeCodeLoader;

public class ZlibCompressor
implements Compressor {
    private static final Log LOG = LogFactory.getLog(ZlibCompressor.class);
    private static final int DEFAULT_DIRECT_BUFFER_SIZE = 65536;
    private static Class clazz = ZlibCompressor.class;
    private long stream;
    private CompressionLevel level;
    private CompressionStrategy strategy;
    private final CompressionHeader windowBits;
    private int directBufferSize;
    private byte[] userBuf = null;
    private int userBufOff = 0;
    private int userBufLen = 0;
    private Buffer uncompressedDirectBuf = null;
    private int uncompressedDirectBufOff = 0;
    private int uncompressedDirectBufLen = 0;
    private boolean keepUncompressedBuf = false;
    private Buffer compressedDirectBuf = null;
    private boolean finish;
    private boolean finished;
    private static boolean nativeZlibLoaded = false;

    static boolean isNativeZlibLoaded() {
        return nativeZlibLoaded;
    }

    protected final void construct(CompressionLevel level, CompressionStrategy strategy, CompressionHeader header, int directBufferSize) {
    }

    public ZlibCompressor() {
        this(CompressionLevel.DEFAULT_COMPRESSION, CompressionStrategy.DEFAULT_STRATEGY, CompressionHeader.DEFAULT_HEADER, 65536);
    }

    public ZlibCompressor(Configuration conf) {
        this(ZlibFactory.getCompressionLevel(conf), ZlibFactory.getCompressionStrategy(conf), CompressionHeader.DEFAULT_HEADER, 65536);
    }

    public ZlibCompressor(CompressionLevel level, CompressionStrategy strategy, CompressionHeader header, int directBufferSize) {
        this.level = level;
        this.strategy = strategy;
        this.windowBits = header;
        this.stream = ZlibCompressor.init(this.level.compressionLevel(), this.strategy.compressionStrategy(), this.windowBits.windowBits());
        this.directBufferSize = directBufferSize;
        this.uncompressedDirectBuf = ByteBuffer.allocateDirect(directBufferSize);
        this.compressedDirectBuf = ByteBuffer.allocateDirect(directBufferSize);
        this.compressedDirectBuf.position(directBufferSize);
    }

    @Override
    public void reinit(Configuration conf) {
        this.reset();
        if (conf == null) {
            return;
        }
        ZlibCompressor.end(this.stream);
        this.level = ZlibFactory.getCompressionLevel(conf);
        this.strategy = ZlibFactory.getCompressionStrategy(conf);
        this.stream = ZlibCompressor.init(this.level.compressionLevel(), this.strategy.compressionStrategy(), this.windowBits.windowBits());
        if (LOG.isDebugEnabled()) {
            LOG.debug("Reinit compressor with new compression configuration");
        }
    }

    @Override
    public void setInput(byte[] b, int off, int len) {
        if (b == null) {
            throw new NullPointerException();
        }
        if (off < 0 || len < 0 || off > b.length - len) {
            throw new ArrayIndexOutOfBoundsException();
        }
        this.userBuf = b;
        this.userBufOff = off;
        this.userBufLen = len;
        this.uncompressedDirectBufOff = 0;
        this.setInputFromSavedData();
        this.compressedDirectBuf.limit(this.directBufferSize);
        this.compressedDirectBuf.position(this.directBufferSize);
    }

    void setInputFromSavedData() {
        int len = Math.min(this.userBufLen, this.uncompressedDirectBuf.remaining());
        ((ByteBuffer)this.uncompressedDirectBuf).put(this.userBuf, this.userBufOff, len);
        this.userBufLen -= len;
        this.userBufOff += len;
        this.uncompressedDirectBufLen = this.uncompressedDirectBuf.position();
    }

    @Override
    public void setDictionary(byte[] b, int off, int len) {
        if (this.stream == 0L || b == null) {
            throw new NullPointerException();
        }
        if (off < 0 || len < 0 || off > b.length - len) {
            throw new ArrayIndexOutOfBoundsException();
        }
        ZlibCompressor.setDictionary(this.stream, b, off, len);
    }

    @Override
    public boolean needsInput() {
        if (this.compressedDirectBuf.remaining() > 0) {
            return false;
        }
        if (this.keepUncompressedBuf && this.uncompressedDirectBufLen > 0) {
            return false;
        }
        if (this.uncompressedDirectBuf.remaining() > 0) {
            if (this.userBufLen <= 0) {
                return true;
            }
            this.setInputFromSavedData();
            return this.uncompressedDirectBuf.remaining() > 0;
        }
        return false;
    }

    @Override
    public void finish() {
        this.finish = true;
    }

    @Override
    public boolean finished() {
        return this.finished && this.compressedDirectBuf.remaining() == 0;
    }

    @Override
    public int compress(byte[] b, int off, int len) throws IOException {
        if (b == null) {
            throw new NullPointerException();
        }
        if (off < 0 || len < 0 || off > b.length - len) {
            throw new ArrayIndexOutOfBoundsException();
        }
        int n = 0;
        n = this.compressedDirectBuf.remaining();
        if (n > 0) {
            n = Math.min(n, len);
            ((ByteBuffer)this.compressedDirectBuf).get(b, off, n);
            return n;
        }
        this.compressedDirectBuf.rewind();
        this.compressedDirectBuf.limit(this.directBufferSize);
        n = this.deflateBytesDirect();
        this.compressedDirectBuf.limit(n);
        if (this.uncompressedDirectBufLen <= 0) {
            this.keepUncompressedBuf = false;
            this.uncompressedDirectBuf.clear();
            this.uncompressedDirectBufOff = 0;
            this.uncompressedDirectBufLen = 0;
        } else {
            this.keepUncompressedBuf = true;
        }
        n = Math.min(n, len);
        ((ByteBuffer)this.compressedDirectBuf).get(b, off, n);
        return n;
    }

    @Override
    public long getBytesWritten() {
        this.checkStream();
        return ZlibCompressor.getBytesWritten(this.stream);
    }

    @Override
    public long getBytesRead() {
        this.checkStream();
        return ZlibCompressor.getBytesRead(this.stream);
    }

    @Override
    public void reset() {
        this.checkStream();
        ZlibCompressor.reset(this.stream);
        this.finish = false;
        this.finished = false;
        this.uncompressedDirectBuf.rewind();
        this.uncompressedDirectBufLen = 0;
        this.uncompressedDirectBufOff = 0;
        this.keepUncompressedBuf = false;
        this.compressedDirectBuf.limit(this.directBufferSize);
        this.compressedDirectBuf.position(this.directBufferSize);
        this.userBufLen = 0;
        this.userBufOff = 0;
    }

    @Override
    public void end() {
        if (this.stream != 0L) {
            ZlibCompressor.end(this.stream);
            this.stream = 0L;
        }
    }

    private void checkStream() {
        if (this.stream == 0L) {
            throw new NullPointerException();
        }
    }

    private static native void initIDs();

    private static native long init(int var0, int var1, int var2);

    private static native void setDictionary(long var0, byte[] var2, int var3, int var4);

    private native int deflateBytesDirect();

    private static native long getBytesRead(long var0);

    private static native long getBytesWritten(long var0);

    private static native void reset(long var0);

    private static native void end(long var0);

    public static native String getLibraryName();

    static {
        if (NativeCodeLoader.isNativeCodeLoaded()) {
            try {
                ZlibCompressor.initIDs();
                nativeZlibLoaded = true;
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    public static enum CompressionHeader {
        NO_HEADER(-15),
        DEFAULT_HEADER(15),
        GZIP_FORMAT(31);

        private final int windowBits;

        private CompressionHeader(int windowBits) {
            this.windowBits = windowBits;
        }

        public int windowBits() {
            return this.windowBits;
        }
    }

    public static enum CompressionStrategy {
        FILTERED(1),
        HUFFMAN_ONLY(2),
        RLE(3),
        FIXED(4),
        DEFAULT_STRATEGY(0);

        private final int compressionStrategy;

        private CompressionStrategy(int strategy) {
            this.compressionStrategy = strategy;
        }

        int compressionStrategy() {
            return this.compressionStrategy;
        }
    }

    public static enum CompressionLevel {
        NO_COMPRESSION(0),
        BEST_SPEED(1),
        TWO(2),
        THREE(3),
        FOUR(4),
        FIVE(5),
        SIX(6),
        SEVEN(7),
        EIGHT(8),
        BEST_COMPRESSION(9),
        DEFAULT_COMPRESSION(-1);

        private final int compressionLevel;

        private CompressionLevel(int level) {
            this.compressionLevel = level;
        }

        int compressionLevel() {
            return this.compressionLevel;
        }
    }
}

