/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.fs.s3presto.shaded.org.apache.hadoop.io;

import java.io.IOException;
import org.apache.flink.fs.s3presto.shaded.org.apache.hadoop.classification.InterfaceAudience;
import org.apache.flink.fs.s3presto.shaded.org.apache.hadoop.classification.InterfaceStability;
import org.apache.flink.fs.s3presto.shaded.org.apache.hadoop.conf.Configuration;
import org.apache.flink.fs.s3presto.shaded.org.apache.hadoop.fs.FileSystem;
import org.apache.flink.fs.s3presto.shaded.org.apache.hadoop.fs.Path;
import org.apache.flink.fs.s3presto.shaded.org.apache.hadoop.io.MapFile;
import org.apache.flink.fs.s3presto.shaded.org.apache.hadoop.io.NullWritable;
import org.apache.flink.fs.s3presto.shaded.org.apache.hadoop.io.SequenceFile;
import org.apache.flink.fs.s3presto.shaded.org.apache.hadoop.io.WritableComparable;
import org.apache.flink.fs.s3presto.shaded.org.apache.hadoop.io.WritableComparator;

@InterfaceAudience.Public
@InterfaceStability.Stable
public class SetFile
extends MapFile {
    protected SetFile() {
    }

    public static class Reader
    extends MapFile.Reader {
        public Reader(FileSystem fs, String dirName, Configuration conf) throws IOException {
            super(fs, dirName, conf);
        }

        public Reader(FileSystem fs, String dirName, WritableComparator comparator, Configuration conf) throws IOException {
            super(new Path(dirName), conf, Reader.comparator(comparator));
        }

        @Override
        public boolean seek(WritableComparable key) throws IOException {
            return super.seek(key);
        }

        public boolean next(WritableComparable key) throws IOException {
            return this.next(key, NullWritable.get());
        }

        public WritableComparable get(WritableComparable key) throws IOException {
            if (this.seek(key)) {
                this.next(key);
                return key;
            }
            return null;
        }
    }

    public static class Writer
    extends MapFile.Writer {
        public Writer(FileSystem fs, String dirName, Class<? extends WritableComparable> keyClass) throws IOException {
            super(new Configuration(), fs, dirName, keyClass, NullWritable.class);
        }

        public Writer(Configuration conf, FileSystem fs, String dirName, Class<? extends WritableComparable> keyClass, SequenceFile.CompressionType compress) throws IOException {
            this(conf, fs, dirName, WritableComparator.get(keyClass, conf), compress);
        }

        public Writer(Configuration conf, FileSystem fs, String dirName, WritableComparator comparator, SequenceFile.CompressionType compress) throws IOException {
            super(conf, new Path(dirName), Writer.comparator(comparator), Writer.valueClass(NullWritable.class), Writer.compression(compress));
        }

        public void append(WritableComparable key) throws IOException {
            this.append(key, NullWritable.get());
        }
    }
}

