/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.fs.s3presto.shaded.org.apache.hadoop.hdfs.util;

import java.util.Arrays;
import java.util.HashMap;
import org.apache.flink.fs.s3presto.shaded.com.facebook.presto.hadoop.$internal.com.google.common.base.Preconditions;
import org.apache.flink.fs.s3presto.shaded.com.facebook.presto.hadoop.$internal.org.apache.commons.lang.ArrayUtils;

public class EnumCounters<E extends Enum<E>> {
    private final Class<E> enumClass;
    private final long[] counters;

    public EnumCounters(Class<E> enumClass) {
        Enum[] enumConstants = (Enum[])enumClass.getEnumConstants();
        Preconditions.checkNotNull(enumConstants);
        this.enumClass = enumClass;
        this.counters = new long[enumConstants.length];
    }

    public EnumCounters(Class<E> enumClass, long defaultVal) {
        Enum[] enumConstants = (Enum[])enumClass.getEnumConstants();
        Preconditions.checkNotNull(enumConstants);
        this.enumClass = enumClass;
        this.counters = new long[enumConstants.length];
        this.reset(defaultVal);
    }

    public final long get(E e) {
        return this.counters[((Enum)e).ordinal()];
    }

    public long[] asArray() {
        return ArrayUtils.clone(this.counters);
    }

    public final void negation() {
        for (int i = 0; i < this.counters.length; ++i) {
            this.counters[i] = -this.counters[i];
        }
    }

    public final void set(E e, long value) {
        this.counters[((Enum)e).ordinal()] = value;
    }

    public final void set(EnumCounters<E> that) {
        for (int i = 0; i < this.counters.length; ++i) {
            this.counters[i] = that.counters[i];
        }
    }

    public final void reset() {
        this.reset(0L);
    }

    public final void add(E e, long value) {
        int n = ((Enum)e).ordinal();
        this.counters[n] = this.counters[n] + value;
    }

    public final void add(EnumCounters<E> that) {
        for (int i = 0; i < this.counters.length; ++i) {
            int n = i;
            this.counters[n] = this.counters[n] + that.counters[i];
        }
    }

    public final void subtract(E e, long value) {
        int n = ((Enum)e).ordinal();
        this.counters[n] = this.counters[n] - value;
    }

    public final void subtract(EnumCounters<E> that) {
        for (int i = 0; i < this.counters.length; ++i) {
            int n = i;
            this.counters[n] = this.counters[n] - that.counters[i];
        }
    }

    public final long sum() {
        long sum = 0L;
        for (int i = 0; i < this.counters.length; ++i) {
            sum += this.counters[i];
        }
        return sum;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || !(obj instanceof EnumCounters)) {
            return false;
        }
        EnumCounters that = (EnumCounters)obj;
        return this.enumClass == that.enumClass && Arrays.equals(this.counters, that.counters);
    }

    public int hashCode() {
        return Arrays.hashCode(this.counters);
    }

    public String toString() {
        Enum[] enumConstants = (Enum[])this.enumClass.getEnumConstants();
        StringBuilder b = new StringBuilder();
        for (int i = 0; i < this.counters.length; ++i) {
            String name = enumConstants[i].name();
            b.append(name).append("=").append(this.counters[i]).append(", ");
        }
        return b.substring(0, b.length() - 2);
    }

    public final void reset(long val) {
        for (int i = 0; i < this.counters.length; ++i) {
            this.counters[i] = val;
        }
    }

    public boolean allLessOrEqual(long val) {
        for (long c : this.counters) {
            if (c <= val) continue;
            return false;
        }
        return true;
    }

    public boolean anyGreaterOrEqual(long val) {
        for (long c : this.counters) {
            if (c < val) continue;
            return true;
        }
        return false;
    }

    public static class Map<K, E extends Enum<E>, C extends EnumCounters<E>> {
        private final Factory<E, C> factory;
        private final java.util.Map<K, C> counts = new HashMap<K, C>();

        public Map(Factory<E, C> factory) {
            this.factory = factory;
        }

        public final C getCounts(K key) {
            EnumCounters<Object> c = (EnumCounters)this.counts.get(key);
            if (c == null) {
                c = this.factory.newInstance();
                this.counts.put(key, c);
            }
            return (C)c;
        }

        public final C sum() {
            C sum = this.factory.newInstance();
            for (EnumCounters c : this.counts.values()) {
                ((EnumCounters)sum).add(c);
            }
            return sum;
        }

        public final long sum(E e) {
            long sum = 0L;
            for (EnumCounters c : this.counts.values()) {
                sum += c.get(e);
            }
            return sum;
        }

        public String toString() {
            return this.counts.toString();
        }
    }

    public static interface Factory<E extends Enum<E>, C extends EnumCounters<E>> {
        public C newInstance();
    }
}

