/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.fs.s3presto.shaded.org.apache.hadoop.hdfs.tools.offlineImageViewer;

import java.io.IOException;
import java.io.PrintStream;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.apache.flink.fs.s3presto.shaded.org.apache.hadoop.fs.Path;
import org.apache.flink.fs.s3presto.shaded.org.apache.hadoop.fs.permission.PermissionStatus;
import org.apache.flink.fs.s3presto.shaded.org.apache.hadoop.hdfs.server.namenode.FsImageProto;
import org.apache.flink.fs.s3presto.shaded.org.apache.hadoop.hdfs.tools.offlineImageViewer.FSImageLoader;
import org.apache.flink.fs.s3presto.shaded.org.apache.hadoop.hdfs.tools.offlineImageViewer.PBImageTextWriter;

public class PBImageDelimitedTextWriter
extends PBImageTextWriter {
    static final String DEFAULT_DELIMITER = "\t";
    private static final String DATE_FORMAT = "yyyy-MM-dd HH:mm";
    private final SimpleDateFormat dateFormatter = new SimpleDateFormat("yyyy-MM-dd HH:mm");
    private final String delimiter;

    PBImageDelimitedTextWriter(PrintStream out, String delimiter, String tempPath) throws IOException {
        super(out, tempPath);
        this.delimiter = delimiter;
    }

    private String formatDate(long date) {
        return this.dateFormatter.format(new Date(date));
    }

    private void append(StringBuffer buffer, int field) {
        buffer.append(this.delimiter);
        buffer.append(field);
    }

    private void append(StringBuffer buffer, long field) {
        buffer.append(this.delimiter);
        buffer.append(field);
    }

    private void append(StringBuffer buffer, String field) {
        buffer.append(this.delimiter);
        buffer.append(field);
    }

    @Override
    public String getEntry(String parent, FsImageProto.INodeSection.INode inode) {
        StringBuffer buffer = new StringBuffer();
        String inodeName = inode.getName().toStringUtf8();
        Path path = new Path(parent.isEmpty() ? "/" : parent, inodeName.isEmpty() ? "/" : inodeName);
        buffer.append(path.toString());
        PermissionStatus p = null;
        switch (inode.getType()) {
            case FILE: {
                FsImageProto.INodeSection.INodeFile file = inode.getFile();
                p = this.getPermission(file.getPermission());
                this.append(buffer, file.getReplication());
                this.append(buffer, this.formatDate(file.getModificationTime()));
                this.append(buffer, this.formatDate(file.getAccessTime()));
                this.append(buffer, file.getPreferredBlockSize());
                this.append(buffer, file.getBlocksCount());
                this.append(buffer, FSImageLoader.getFileSize(file));
                this.append(buffer, 0);
                this.append(buffer, 0);
                break;
            }
            case DIRECTORY: {
                FsImageProto.INodeSection.INodeDirectory dir = inode.getDirectory();
                p = this.getPermission(dir.getPermission());
                this.append(buffer, 0);
                this.append(buffer, this.formatDate(dir.getModificationTime()));
                this.append(buffer, this.formatDate(0L));
                this.append(buffer, 0);
                this.append(buffer, 0);
                this.append(buffer, 0);
                this.append(buffer, dir.getNsQuota());
                this.append(buffer, dir.getDsQuota());
                break;
            }
            case SYMLINK: {
                FsImageProto.INodeSection.INodeSymlink s = inode.getSymlink();
                p = this.getPermission(s.getPermission());
                this.append(buffer, 0);
                this.append(buffer, this.formatDate(s.getModificationTime()));
                this.append(buffer, this.formatDate(s.getAccessTime()));
                this.append(buffer, 0);
                this.append(buffer, 0);
                this.append(buffer, 0);
                this.append(buffer, 0);
                this.append(buffer, 0);
                break;
            }
        }
        assert (p != null);
        this.append(buffer, p.getPermission().toString());
        this.append(buffer, p.getUserName());
        this.append(buffer, p.getGroupName());
        return buffer.toString();
    }
}

