/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.fs.s3presto.shaded.org.apache.hadoop.hdfs.tools.offlineImageViewer;

import java.io.IOException;
import java.util.Formatter;
import java.util.LinkedList;
import org.apache.flink.fs.s3presto.shaded.org.apache.hadoop.hdfs.tools.offlineImageViewer.ImageVisitor;
import org.apache.flink.fs.s3presto.shaded.org.apache.hadoop.hdfs.tools.offlineImageViewer.TextWriterImageVisitor;

class LsImageVisitor
extends TextWriterImageVisitor {
    private final LinkedList<ImageVisitor.ImageElement> elemQ = new LinkedList();
    private int numBlocks;
    private String perms;
    private int replication;
    private String username;
    private String group;
    private long filesize;
    private String modTime;
    private String path;
    private String linkTarget;
    private boolean inInode = false;
    private final StringBuilder sb = new StringBuilder();
    private final Formatter formatter = new Formatter(this.sb);
    private static final int widthRepl = 2;
    private static final int widthUser = 8;
    private static final int widthGroup = 10;
    private static final int widthSize = 10;
    private static final int widthMod = 10;
    private static final String lsStr = " %2s %8s %10s %10d %10s %s";

    public LsImageVisitor(String filename) throws IOException {
        super(filename);
    }

    public LsImageVisitor(String filename, boolean printToScreen) throws IOException {
        super(filename, printToScreen);
    }

    private void newLine() {
        this.numBlocks = 0;
        this.linkTarget = "";
        this.path = "";
        this.group = "";
        this.username = "";
        this.perms = "";
        this.filesize = 0L;
        this.replication = 0;
        this.inInode = true;
    }

    private void printLine() throws IOException {
        this.sb.append(this.numBlocks < 0 ? "d" : "-");
        this.sb.append(this.perms);
        if (0 != this.linkTarget.length()) {
            this.path = this.path + " -> " + this.linkTarget;
        }
        this.formatter.format(lsStr, this.replication > 0 ? Integer.valueOf(this.replication) : "-", this.username, this.group, this.filesize, this.modTime, this.path);
        this.sb.append("\n");
        this.write(this.sb.toString());
        this.sb.setLength(0);
        this.inInode = false;
    }

    @Override
    void start() throws IOException {
    }

    @Override
    void finish() throws IOException {
        super.finish();
    }

    @Override
    void finishAbnormally() throws IOException {
        System.out.println("Input ended unexpectedly.");
        super.finishAbnormally();
    }

    @Override
    void leaveEnclosingElement() throws IOException {
        ImageVisitor.ImageElement elem = this.elemQ.pop();
        if (elem == ImageVisitor.ImageElement.INODE) {
            this.printLine();
        }
    }

    @Override
    void visit(ImageVisitor.ImageElement element, String value) throws IOException {
        if (this.inInode) {
            switch (element) {
                case INODE_PATH: {
                    if (value.equals("")) {
                        this.path = "/";
                        break;
                    }
                    this.path = value;
                    break;
                }
                case PERMISSION_STRING: {
                    this.perms = value;
                    break;
                }
                case REPLICATION: {
                    this.replication = Integer.parseInt(value);
                    break;
                }
                case USER_NAME: {
                    this.username = value;
                    break;
                }
                case GROUP_NAME: {
                    this.group = value;
                    break;
                }
                case NUM_BYTES: {
                    this.filesize += Long.parseLong(value);
                    break;
                }
                case MODIFICATION_TIME: {
                    this.modTime = value;
                    break;
                }
                case SYMLINK: {
                    this.linkTarget = value;
                    break;
                }
            }
        }
    }

    @Override
    void visitEnclosingElement(ImageVisitor.ImageElement element) throws IOException {
        this.elemQ.push(element);
        if (element == ImageVisitor.ImageElement.INODE) {
            this.newLine();
        }
    }

    @Override
    void visitEnclosingElement(ImageVisitor.ImageElement element, ImageVisitor.ImageElement key, String value) throws IOException {
        this.elemQ.push(element);
        if (element == ImageVisitor.ImageElement.INODE) {
            this.newLine();
        } else if (element == ImageVisitor.ImageElement.BLOCKS) {
            this.numBlocks = Integer.parseInt(value);
        }
    }
}

