/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.fs.s3presto.shaded.org.apache.hadoop.hdfs.tools.offlineImageViewer;

import java.io.IOException;
import java.util.LinkedList;
import org.apache.flink.fs.s3presto.shaded.org.apache.hadoop.hdfs.tools.offlineImageViewer.ImageVisitor;
import org.apache.flink.fs.s3presto.shaded.org.apache.hadoop.hdfs.tools.offlineImageViewer.TextWriterImageVisitor;

class FileDistributionVisitor
extends TextWriterImageVisitor {
    private final LinkedList<ImageVisitor.ImageElement> elemS = new LinkedList();
    private static final long MAX_SIZE_DEFAULT = 0x2000000000L;
    private static final int INTERVAL_DEFAULT = 0x200000;
    private int[] distribution;
    private long maxSize;
    private int step;
    private int totalFiles;
    private int totalDirectories;
    private int totalBlocks;
    private long totalSpace;
    private long maxFileSize;
    private FileContext current;
    private boolean inInode = false;

    public FileDistributionVisitor(String filename, long maxSize, int step) throws IOException {
        super(filename, false);
        this.maxSize = maxSize == 0L ? 0x2000000000L : maxSize;
        this.step = step == 0 ? 0x200000 : step;
        long numIntervals = this.maxSize / (long)this.step;
        if (numIntervals >= Integer.MAX_VALUE) {
            throw new IOException("Too many distribution intervals " + numIntervals);
        }
        this.distribution = new int[1 + (int)numIntervals];
        this.totalFiles = 0;
        this.totalDirectories = 0;
        this.totalBlocks = 0;
        this.totalSpace = 0L;
        this.maxFileSize = 0L;
    }

    @Override
    void start() throws IOException {
    }

    @Override
    void finish() throws IOException {
        this.output();
        super.finish();
    }

    @Override
    void finishAbnormally() throws IOException {
        System.out.println("*** Image processing finished abnormally.  Ending ***");
        this.output();
        super.finishAbnormally();
    }

    private void output() throws IOException {
        this.write("Size\tNumFiles\n");
        for (int i = 0; i < this.distribution.length; ++i) {
            this.write((long)i * (long)this.step + "\t" + this.distribution[i] + "\n");
        }
        System.out.println("totalFiles = " + this.totalFiles);
        System.out.println("totalDirectories = " + this.totalDirectories);
        System.out.println("totalBlocks = " + this.totalBlocks);
        System.out.println("totalSpace = " + this.totalSpace);
        System.out.println("maxFileSize = " + this.maxFileSize);
    }

    @Override
    void leaveEnclosingElement() throws IOException {
        ImageVisitor.ImageElement elem = this.elemS.pop();
        if (elem != ImageVisitor.ImageElement.INODE && elem != ImageVisitor.ImageElement.INODE_UNDER_CONSTRUCTION) {
            return;
        }
        this.inInode = false;
        if (this.current.numBlocks < 0) {
            ++this.totalDirectories;
            return;
        }
        ++this.totalFiles;
        this.totalBlocks += this.current.numBlocks;
        this.totalSpace += this.current.fileSize * (long)this.current.replication;
        if (this.maxFileSize < this.current.fileSize) {
            this.maxFileSize = this.current.fileSize;
        }
        int high = this.current.fileSize > this.maxSize ? this.distribution.length - 1 : (int)Math.ceil((double)this.current.fileSize / (double)this.step);
        int n = high;
        this.distribution[n] = this.distribution[n] + 1;
        if (this.totalFiles % 1000000 == 1) {
            System.out.println("Files processed: " + this.totalFiles + "  Current: " + this.current.path);
        }
    }

    @Override
    void visit(ImageVisitor.ImageElement element, String value) throws IOException {
        if (this.inInode) {
            switch (element) {
                case INODE_PATH: {
                    this.current.path = value.equals("") ? "/" : value;
                    break;
                }
                case REPLICATION: {
                    this.current.replication = Integer.parseInt(value);
                    break;
                }
                case NUM_BYTES: {
                    this.current.fileSize += Long.parseLong(value);
                    break;
                }
            }
        }
    }

    @Override
    void visitEnclosingElement(ImageVisitor.ImageElement element) throws IOException {
        this.elemS.push(element);
        if (element == ImageVisitor.ImageElement.INODE || element == ImageVisitor.ImageElement.INODE_UNDER_CONSTRUCTION) {
            this.current = new FileContext();
            this.inInode = true;
        }
    }

    @Override
    void visitEnclosingElement(ImageVisitor.ImageElement element, ImageVisitor.ImageElement key, String value) throws IOException {
        this.elemS.push(element);
        if (element == ImageVisitor.ImageElement.INODE || element == ImageVisitor.ImageElement.INODE_UNDER_CONSTRUCTION) {
            this.inInode = true;
        } else if (element == ImageVisitor.ImageElement.BLOCKS) {
            this.current.numBlocks = Integer.parseInt(value);
        }
    }

    private static class FileContext {
        String path;
        long fileSize;
        int numBlocks;
        int replication;

        private FileContext() {
        }
    }
}

