/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.fs.s3presto.shaded.org.apache.hadoop.hdfs.tools;

import java.io.IOException;
import java.util.LinkedList;
import java.util.List;
import org.apache.flink.fs.s3presto.shaded.org.apache.hadoop.classification.InterfaceAudience;
import org.apache.flink.fs.s3presto.shaded.org.apache.hadoop.conf.Configuration;
import org.apache.flink.fs.s3presto.shaded.org.apache.hadoop.conf.Configured;
import org.apache.flink.fs.s3presto.shaded.org.apache.hadoop.fs.Path;
import org.apache.flink.fs.s3presto.shaded.org.apache.hadoop.fs.RemoteIterator;
import org.apache.flink.fs.s3presto.shaded.org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.flink.fs.s3presto.shaded.org.apache.hadoop.hdfs.protocol.EncryptionZone;
import org.apache.flink.fs.s3presto.shaded.org.apache.hadoop.hdfs.tools.AdminHelper;
import org.apache.flink.fs.s3presto.shaded.org.apache.hadoop.tools.TableListing;
import org.apache.flink.fs.s3presto.shaded.org.apache.hadoop.util.StringUtils;
import org.apache.flink.fs.s3presto.shaded.org.apache.hadoop.util.Tool;

@InterfaceAudience.Private
public class CryptoAdmin
extends Configured
implements Tool {
    private static final AdminHelper.Command[] COMMANDS = new AdminHelper.Command[]{new CreateZoneCommand(), new ListZonesCommand()};

    public CryptoAdmin() {
        this(null);
    }

    public CryptoAdmin(Configuration conf) {
        super(conf);
    }

    @Override
    public int run(String[] args) throws IOException {
        if (args.length == 0) {
            AdminHelper.printUsage(false, "crypto", COMMANDS);
            return 1;
        }
        AdminHelper.Command command = AdminHelper.determineCommand(args[0], COMMANDS);
        if (command == null) {
            System.err.println("Can't understand command '" + args[0] + "'");
            if (!args[0].startsWith("-")) {
                System.err.println("Command names must start with dashes.");
            }
            AdminHelper.printUsage(false, "crypto", COMMANDS);
            return 1;
        }
        LinkedList<String> argsList = new LinkedList<String>();
        for (int j = 1; j < args.length; ++j) {
            argsList.add(args[j]);
        }
        try {
            return command.run(this.getConf(), argsList);
        }
        catch (IllegalArgumentException e) {
            System.err.println(CryptoAdmin.prettifyException(e));
            return -1;
        }
    }

    public static void main(String[] argsArray) throws IOException {
        CryptoAdmin cryptoAdmin = new CryptoAdmin(new Configuration());
        System.exit(cryptoAdmin.run(argsArray));
    }

    private static String prettifyException(Exception e) {
        return e.getClass().getSimpleName() + ": " + e.getLocalizedMessage().split("\n")[0];
    }

    private static class ListZonesCommand
    implements AdminHelper.Command {
        private ListZonesCommand() {
        }

        @Override
        public String getName() {
            return "-listZones";
        }

        @Override
        public String getShortUsage() {
            return "[" + this.getName() + "]\n";
        }

        @Override
        public String getLongUsage() {
            return this.getShortUsage() + "\n" + "List all encryption zones. Requires superuser permissions.\n\n";
        }

        @Override
        public int run(Configuration conf, List<String> args) throws IOException {
            if (!args.isEmpty()) {
                System.err.println("Can't understand argument: " + args.get(0));
                return 1;
            }
            DistributedFileSystem dfs = AdminHelper.getDFS(conf);
            try {
                TableListing listing = new TableListing.Builder().addField("").addField("", true).wrapWidth(80).hideHeaders().build();
                RemoteIterator<EncryptionZone> it = dfs.listEncryptionZones();
                while (it.hasNext()) {
                    EncryptionZone ez = it.next();
                    listing.addRow(ez.getPath(), ez.getKeyName());
                }
                System.out.println(listing.toString());
            }
            catch (IOException e) {
                System.err.println(CryptoAdmin.prettifyException(e));
                return 2;
            }
            return 0;
        }
    }

    private static class CreateZoneCommand
    implements AdminHelper.Command {
        private CreateZoneCommand() {
        }

        @Override
        public String getName() {
            return "-createZone";
        }

        @Override
        public String getShortUsage() {
            return "[" + this.getName() + " -keyName <keyName> -path <path>]\n";
        }

        @Override
        public String getLongUsage() {
            TableListing listing = AdminHelper.getOptionDescriptionListing();
            listing.addRow("<path>", "The path of the encryption zone to create. It must be an empty directory.");
            listing.addRow("<keyName>", "Name of the key to use for the encryption zone.");
            return this.getShortUsage() + "\n" + "Create a new encryption zone.\n\n" + listing.toString();
        }

        @Override
        public int run(Configuration conf, List<String> args) throws IOException {
            String path = StringUtils.popOptionWithArgument("-path", args);
            if (path == null) {
                System.err.println("You must specify a path with -path.");
                return 1;
            }
            String keyName = StringUtils.popOptionWithArgument("-keyName", args);
            if (keyName == null) {
                System.err.println("You must specify a key name with -keyName.");
                return 1;
            }
            if (!args.isEmpty()) {
                System.err.println("Can't understand argument: " + args.get(0));
                return 1;
            }
            DistributedFileSystem dfs = AdminHelper.getDFS(conf);
            try {
                dfs.createEncryptionZone(new Path(path), keyName);
                System.out.println("Added encryption zone " + path);
            }
            catch (IOException e) {
                System.err.println(CryptoAdmin.prettifyException(e));
                return 2;
            }
            return 0;
        }
    }
}

