/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.fs.s3presto.shaded.org.apache.hadoop.hdfs.shortcircuit;

import java.io.BufferedOutputStream;
import java.io.Closeable;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.nio.MappedByteBuffer;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.flink.fs.s3presto.shaded.com.facebook.presto.hadoop.$internal.com.google.common.annotations.VisibleForTesting;
import org.apache.flink.fs.s3presto.shaded.com.facebook.presto.hadoop.$internal.com.google.common.base.Preconditions;
import org.apache.flink.fs.s3presto.shaded.com.facebook.presto.hadoop.$internal.com.google.common.util.concurrent.ThreadFactoryBuilder;
import org.apache.flink.fs.s3presto.shaded.com.facebook.presto.hadoop.$internal.org.apache.commons.lang.mutable.MutableBoolean;
import org.apache.flink.fs.s3presto.shaded.com.facebook.presto.hadoop.$internal.org.apache.commons.logging.Log;
import org.apache.flink.fs.s3presto.shaded.com.facebook.presto.hadoop.$internal.org.apache.commons.logging.LogFactory;
import org.apache.flink.fs.s3presto.shaded.org.apache.hadoop.classification.InterfaceAudience;
import org.apache.flink.fs.s3presto.shaded.org.apache.hadoop.conf.Configuration;
import org.apache.flink.fs.s3presto.shaded.org.apache.hadoop.hdfs.ExtendedBlockId;
import org.apache.flink.fs.s3presto.shaded.org.apache.hadoop.hdfs.net.DomainPeer;
import org.apache.flink.fs.s3presto.shaded.org.apache.hadoop.hdfs.protocol.DatanodeInfo;
import org.apache.flink.fs.s3presto.shaded.org.apache.hadoop.hdfs.protocol.datatransfer.Sender;
import org.apache.flink.fs.s3presto.shaded.org.apache.hadoop.hdfs.protocol.proto.DataTransferProtos;
import org.apache.flink.fs.s3presto.shaded.org.apache.hadoop.hdfs.protocolPB.PBHelper;
import org.apache.flink.fs.s3presto.shaded.org.apache.hadoop.hdfs.shortcircuit.ClientMmap;
import org.apache.flink.fs.s3presto.shaded.org.apache.hadoop.hdfs.shortcircuit.DfsClientShm;
import org.apache.flink.fs.s3presto.shaded.org.apache.hadoop.hdfs.shortcircuit.DfsClientShmManager;
import org.apache.flink.fs.s3presto.shaded.org.apache.hadoop.hdfs.shortcircuit.ShortCircuitReplica;
import org.apache.flink.fs.s3presto.shaded.org.apache.hadoop.hdfs.shortcircuit.ShortCircuitReplicaInfo;
import org.apache.flink.fs.s3presto.shaded.org.apache.hadoop.hdfs.shortcircuit.ShortCircuitShm;
import org.apache.flink.fs.s3presto.shaded.org.apache.hadoop.io.IOUtils;
import org.apache.flink.fs.s3presto.shaded.org.apache.hadoop.ipc.RetriableException;
import org.apache.flink.fs.s3presto.shaded.org.apache.hadoop.net.unix.DomainSocket;
import org.apache.flink.fs.s3presto.shaded.org.apache.hadoop.net.unix.DomainSocketWatcher;
import org.apache.flink.fs.s3presto.shaded.org.apache.hadoop.security.token.SecretManager;
import org.apache.flink.fs.s3presto.shaded.org.apache.hadoop.util.StringUtils;
import org.apache.flink.fs.s3presto.shaded.org.apache.hadoop.util.Time;
import org.apache.flink.fs.s3presto.shaded.org.apache.hadoop.util.Waitable;

@InterfaceAudience.Private
public class ShortCircuitCache
implements Closeable {
    public static final Log LOG = LogFactory.getLog(ShortCircuitCache.class);
    private final ReentrantLock lock = new ReentrantLock();
    private final ScheduledThreadPoolExecutor cleanerExecutor = new ScheduledThreadPoolExecutor(1, new ThreadFactoryBuilder().setDaemon(true).setNameFormat("ShortCircuitCache_Cleaner").build());
    private final ScheduledThreadPoolExecutor releaserExecutor = new ScheduledThreadPoolExecutor(1, new ThreadFactoryBuilder().setDaemon(true).setNameFormat("ShortCircuitCache_SlotReleaser").build());
    private final HashMap<ExtendedBlockId, Waitable<ShortCircuitReplicaInfo>> replicaInfoMap = new HashMap();
    private CacheCleaner cacheCleaner;
    private final TreeMap<Long, ShortCircuitReplica> evictable = new TreeMap();
    private final int maxTotalSize;
    private long maxNonMmappedEvictableLifespanMs;
    private final TreeMap<Long, ShortCircuitReplica> evictableMmapped = new TreeMap();
    private int maxEvictableMmapedSize;
    private final long maxEvictableMmapedLifespanMs;
    private final long mmapRetryTimeoutMs;
    private final long staleThresholdMs;
    private boolean closed = false;
    private int outstandingMmapCount = 0;
    private final DfsClientShmManager shmManager;

    public static ShortCircuitCache fromConf(Configuration conf) {
        return new ShortCircuitCache(conf.getInt("dfs.client.read.shortcircuit.streams.cache.size", 256), conf.getLong("dfs.client.read.shortcircuit.streams.cache.expiry.ms", 300000L), conf.getInt("dfs.client.mmap.cache.size", 256), conf.getLong("dfs.client.mmap.cache.timeout.ms", 3600000L), conf.getLong("dfs.client.mmap.retry.timeout.ms", 300000L), conf.getLong("dfs.client.short.circuit.replica.stale.threshold.ms", 1800000L), conf.getInt("dfs.short.circuit.shared.memory.watcher.interrupt.check.ms", 60000));
    }

    public ShortCircuitCache(int maxTotalSize, long maxNonMmappedEvictableLifespanMs, int maxEvictableMmapedSize, long maxEvictableMmapedLifespanMs, long mmapRetryTimeoutMs, long staleThresholdMs, int shmInterruptCheckMs) {
        Preconditions.checkArgument(maxTotalSize >= 0);
        this.maxTotalSize = maxTotalSize;
        Preconditions.checkArgument(maxNonMmappedEvictableLifespanMs >= 0L);
        this.maxNonMmappedEvictableLifespanMs = maxNonMmappedEvictableLifespanMs;
        Preconditions.checkArgument(maxEvictableMmapedSize >= 0);
        this.maxEvictableMmapedSize = maxEvictableMmapedSize;
        Preconditions.checkArgument(maxEvictableMmapedLifespanMs >= 0L);
        this.maxEvictableMmapedLifespanMs = maxEvictableMmapedLifespanMs;
        this.mmapRetryTimeoutMs = mmapRetryTimeoutMs;
        this.staleThresholdMs = staleThresholdMs;
        DfsClientShmManager shmManager = null;
        if (shmInterruptCheckMs > 0 && DomainSocketWatcher.getLoadingFailureReason() == null) {
            try {
                shmManager = new DfsClientShmManager(shmInterruptCheckMs);
            }
            catch (IOException e) {
                LOG.error("failed to create ShortCircuitShmManager", e);
            }
        }
        this.shmManager = shmManager;
    }

    public long getStaleThresholdMs() {
        return this.staleThresholdMs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void ref(ShortCircuitReplica replica) {
        this.lock.lock();
        try {
            Preconditions.checkArgument(replica.refCount > 0, "can't ref %s because its refCount reached %d", replica, replica.refCount);
            Long evictableTimeNs = replica.getEvictableTimeNs();
            ++replica.refCount;
            if (evictableTimeNs != null) {
                String removedFrom = this.removeEvictable(replica);
                if (LOG.isTraceEnabled()) {
                    LOG.trace(this + ": " + removedFrom + " no longer contains " + replica + ".  refCount " + (replica.refCount - 1) + " -> " + replica.refCount + StringUtils.getStackTrace(Thread.currentThread()));
                }
            } else if (LOG.isTraceEnabled()) {
                LOG.trace(this + ": replica  refCount " + (replica.refCount - 1) + " -> " + replica.refCount + StringUtils.getStackTrace(Thread.currentThread()));
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void unref(ShortCircuitReplica replica) {
        this.lock.lock();
        try {
            int newRefCount;
            if (!replica.purged) {
                String purgeReason = null;
                if (!replica.getDataStream().getChannel().isOpen()) {
                    purgeReason = "purging replica because its data channel is closed.";
                } else if (!replica.getMetaStream().getChannel().isOpen()) {
                    purgeReason = "purging replica because its meta channel is closed.";
                } else if (replica.isStale()) {
                    purgeReason = "purging replica because it is stale.";
                }
                if (purgeReason != null) {
                    LOG.debug(this + ": " + purgeReason);
                    this.purge(replica);
                }
            }
            String addedString = "";
            boolean shouldTrimEvictionMaps = false;
            if ((newRefCount = --replica.refCount) == 0) {
                Preconditions.checkArgument(replica.purged, "Replica %s reached a refCount of 0 without being purged", replica);
                replica.close();
            } else if (newRefCount == 1) {
                Preconditions.checkState(null == replica.getEvictableTimeNs(), "Replica %s had a refCount higher than 1, but was still evictable (evictableTimeNs = %d)", replica, replica.getEvictableTimeNs());
                if (!replica.purged) {
                    if (replica.hasMmap()) {
                        this.insertEvictable(System.nanoTime(), replica, this.evictableMmapped);
                        addedString = "added to evictableMmapped, ";
                    } else {
                        this.insertEvictable(System.nanoTime(), replica, this.evictable);
                        addedString = "added to evictable, ";
                    }
                    shouldTrimEvictionMaps = true;
                }
            } else {
                Preconditions.checkArgument(replica.refCount >= 0, "replica's refCount went negative (refCount = %d for %s)", replica.refCount, replica);
            }
            if (LOG.isTraceEnabled()) {
                LOG.trace(this + ": unref replica " + replica + ": " + addedString + " refCount " + (newRefCount + 1) + " -> " + newRefCount + StringUtils.getStackTrace(Thread.currentThread()));
            }
            if (shouldTrimEvictionMaps) {
                this.trimEvictionMaps();
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    private int demoteOldEvictableMmaped(long now) {
        Map.Entry<Long, ShortCircuitReplica> entry;
        int numDemoted = 0;
        boolean needMoreSpace = false;
        Long evictionTimeNs = 0L;
        while ((entry = this.evictableMmapped.ceilingEntry(evictionTimeNs)) != null) {
            evictionTimeNs = entry.getKey();
            long evictionTimeMs = TimeUnit.MILLISECONDS.convert(evictionTimeNs, TimeUnit.NANOSECONDS);
            if (evictionTimeMs + this.maxEvictableMmapedLifespanMs >= now) {
                if (this.evictableMmapped.size() < this.maxEvictableMmapedSize) break;
                needMoreSpace = true;
            }
            ShortCircuitReplica replica = entry.getValue();
            if (LOG.isTraceEnabled()) {
                String rationale = needMoreSpace ? "because we need more space" : "because it's too old";
                LOG.trace("demoteOldEvictable: demoting " + replica + ": " + rationale + ": " + StringUtils.getStackTrace(Thread.currentThread()));
            }
            this.removeEvictable(replica, this.evictableMmapped);
            this.munmap(replica);
            this.insertEvictable(evictionTimeNs, replica, this.evictable);
            ++numDemoted;
        }
        return numDemoted;
    }

    private void trimEvictionMaps() {
        long now = Time.monotonicNow();
        this.demoteOldEvictableMmaped(now);
        long evictableMmappedSize;
        long evictableSize;
        while ((evictableSize = (long)this.evictable.size()) + (evictableMmappedSize = (long)this.evictableMmapped.size()) > (long)this.maxTotalSize) {
            ShortCircuitReplica replica = evictableSize == 0L ? this.evictableMmapped.firstEntry().getValue() : this.evictable.firstEntry().getValue();
            if (LOG.isTraceEnabled()) {
                LOG.trace(this + ": trimEvictionMaps is purging " + replica + StringUtils.getStackTrace(Thread.currentThread()));
            }
            this.purge(replica);
        }
        return;
    }

    private void munmap(ShortCircuitReplica replica) {
        replica.munmap();
        --this.outstandingMmapCount;
    }

    private String removeEvictable(ShortCircuitReplica replica) {
        if (replica.hasMmap()) {
            this.removeEvictable(replica, this.evictableMmapped);
            return "evictableMmapped";
        }
        this.removeEvictable(replica, this.evictable);
        return "evictable";
    }

    private void removeEvictable(ShortCircuitReplica replica, TreeMap<Long, ShortCircuitReplica> map) {
        Long evictableTimeNs = replica.getEvictableTimeNs();
        Preconditions.checkNotNull(evictableTimeNs);
        ShortCircuitReplica removed = map.remove(evictableTimeNs);
        Preconditions.checkState(removed == replica, "failed to make %s unevictable", replica);
        replica.setEvictableTimeNs(null);
    }

    private void insertEvictable(Long evictionTimeNs, ShortCircuitReplica replica, TreeMap<Long, ShortCircuitReplica> map) {
        while (map.containsKey(evictionTimeNs)) {
            Long l = evictionTimeNs;
            Long l2 = evictionTimeNs = Long.valueOf(evictionTimeNs + 1L);
        }
        Preconditions.checkState(null == replica.getEvictableTimeNs());
        replica.setEvictableTimeNs(evictionTimeNs);
        map.put(evictionTimeNs, replica);
    }

    private void purge(ShortCircuitReplica replica) {
        Long evictableTimeNs;
        ShortCircuitReplicaInfo info;
        boolean removedFromInfoMap = false;
        String evictionMapName = null;
        Preconditions.checkArgument(!replica.purged);
        replica.purged = true;
        Waitable<ShortCircuitReplicaInfo> val = this.replicaInfoMap.get(replica.key);
        if (val != null && (info = val.getVal()) != null && info.getReplica() == replica) {
            this.replicaInfoMap.remove(replica.key);
            removedFromInfoMap = true;
        }
        if ((evictableTimeNs = replica.getEvictableTimeNs()) != null) {
            evictionMapName = this.removeEvictable(replica);
        }
        if (LOG.isTraceEnabled()) {
            StringBuilder builder = new StringBuilder();
            builder.append(this).append(": ").append(": purged ").append(replica).append(" from the cache.");
            if (removedFromInfoMap) {
                builder.append("  Removed from the replicaInfoMap.");
            }
            if (evictionMapName != null) {
                builder.append("  Removed from ").append(evictionMapName);
            }
            LOG.trace(builder.toString());
        }
        this.unref(replica);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ShortCircuitReplicaInfo fetchOrCreate(ExtendedBlockId key, ShortCircuitReplicaCreator creator) {
        Waitable<ShortCircuitReplicaInfo> newWaitable = null;
        this.lock.lock();
        try {
            ShortCircuitReplicaInfo info;
            block11: {
                info = null;
                if (this.closed) {
                    if (LOG.isTraceEnabled()) {
                        LOG.trace(this + ": can't fetchOrCreate " + key + " because the cache is closed.");
                    }
                    ShortCircuitReplicaInfo shortCircuitReplicaInfo = null;
                    return shortCircuitReplicaInfo;
                }
                Waitable<ShortCircuitReplicaInfo> waitable = this.replicaInfoMap.get(key);
                if (waitable != null) {
                    try {
                        info = this.fetch(key, waitable);
                    }
                    catch (RetriableException e) {
                        if (!LOG.isDebugEnabled()) break block11;
                        LOG.debug(this + ": retrying " + e.getMessage());
                    }
                }
            }
            if (info != null) {
                ShortCircuitReplicaInfo shortCircuitReplicaInfo = info;
                return shortCircuitReplicaInfo;
            }
            newWaitable = new Waitable<ShortCircuitReplicaInfo>(this.lock.newCondition());
            this.replicaInfoMap.put(key, newWaitable);
        }
        finally {
            this.lock.unlock();
        }
        return this.create(key, creator, newWaitable);
    }

    private ShortCircuitReplicaInfo fetch(ExtendedBlockId key, Waitable<ShortCircuitReplicaInfo> waitable) throws RetriableException {
        ShortCircuitReplicaInfo info;
        try {
            if (LOG.isTraceEnabled()) {
                LOG.trace(this + ": found waitable for " + key);
            }
            info = waitable.await();
        }
        catch (InterruptedException e) {
            LOG.info(this + ": interrupted while waiting for " + key);
            Thread.currentThread().interrupt();
            throw new RetriableException("interrupted");
        }
        if (info.getInvalidTokenException() != null) {
            LOG.info(this + ": could not get " + key + " due to InvalidToken " + "exception.", info.getInvalidTokenException());
            return info;
        }
        ShortCircuitReplica replica = info.getReplica();
        if (replica == null) {
            LOG.warn(this + ": failed to get " + key);
            return info;
        }
        if (replica.purged) {
            throw new RetriableException("Ignoring purged replica " + replica + ".  Retrying.");
        }
        if (replica.isStale()) {
            LOG.info(this + ": got stale replica " + replica + ".  Removing " + "this replica from the replicaInfoMap and retrying.");
            this.purge(replica);
            throw new RetriableException("ignoring stale replica " + replica);
        }
        this.ref(replica);
        return info;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ShortCircuitReplicaInfo create(ExtendedBlockId key, ShortCircuitReplicaCreator creator, Waitable<ShortCircuitReplicaInfo> newWaitable) {
        ShortCircuitReplicaInfo info = null;
        try {
            if (LOG.isTraceEnabled()) {
                LOG.trace(this + ": loading " + key);
            }
            info = creator.createShortCircuitReplicaInfo();
        }
        catch (RuntimeException e) {
            LOG.warn(this + ": failed to load " + key, e);
        }
        if (info == null) {
            info = new ShortCircuitReplicaInfo();
        }
        this.lock.lock();
        try {
            if (info.getReplica() != null) {
                if (LOG.isTraceEnabled()) {
                    LOG.trace(this + ": successfully loaded " + info.getReplica());
                }
                this.startCacheCleanerThreadIfNeeded();
            } else {
                Waitable<ShortCircuitReplicaInfo> waitableInMap = this.replicaInfoMap.get(key);
                if (waitableInMap == newWaitable) {
                    this.replicaInfoMap.remove(key);
                }
                if (info.getInvalidTokenException() != null) {
                    LOG.info(this + ": could not load " + key + " due to InvalidToken " + "exception.", info.getInvalidTokenException());
                } else {
                    LOG.warn(this + ": failed to load " + key);
                }
            }
            newWaitable.provide(info);
        }
        finally {
            this.lock.unlock();
        }
        return info;
    }

    private void startCacheCleanerThreadIfNeeded() {
        if (this.cacheCleaner == null) {
            this.cacheCleaner = new CacheCleaner();
            long rateMs = this.cacheCleaner.getRateInMs();
            ScheduledFuture<?> future = this.cleanerExecutor.scheduleAtFixedRate(this.cacheCleaner, rateMs, rateMs, TimeUnit.MILLISECONDS);
            this.cacheCleaner.setFuture(future);
            if (LOG.isDebugEnabled()) {
                LOG.debug(this + ": starting cache cleaner thread which will run " + "every " + rateMs + " ms");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ClientMmap getOrCreateClientMmap(ShortCircuitReplica replica, boolean anchored) {
        Condition newCond;
        this.lock.lock();
        try {
            while (replica.mmapData != null) {
                if (replica.mmapData instanceof MappedByteBuffer) {
                    this.ref(replica);
                    MappedByteBuffer mmap = (MappedByteBuffer)replica.mmapData;
                    ClientMmap clientMmap = new ClientMmap(replica, mmap, anchored);
                    return clientMmap;
                }
                if (replica.mmapData instanceof Long) {
                    long lastAttemptTimeMs = (Long)replica.mmapData;
                    long delta = Time.monotonicNow() - lastAttemptTimeMs;
                    if (delta < this.mmapRetryTimeoutMs) {
                        if (LOG.isTraceEnabled()) {
                            LOG.trace(this + ": can't create client mmap for " + replica + " because we failed to " + "create one just " + delta + "ms ago.");
                        }
                        ClientMmap clientMmap = null;
                        return clientMmap;
                    }
                    if (!LOG.isTraceEnabled()) continue;
                    LOG.trace(this + ": retrying client mmap for " + replica + ", " + delta + " ms after the previous failure.");
                    continue;
                }
                if (replica.mmapData instanceof Condition) {
                    Condition cond = (Condition)replica.mmapData;
                    cond.awaitUninterruptibly();
                    continue;
                }
                Preconditions.checkState(false, "invalid mmapData type %s", replica.mmapData.getClass().getName());
            }
            newCond = this.lock.newCondition();
            replica.mmapData = newCond;
        }
        finally {
            this.lock.unlock();
        }
        MappedByteBuffer map = replica.loadMmapInternal();
        this.lock.lock();
        try {
            if (map == null) {
                replica.mmapData = Time.monotonicNow();
                newCond.signalAll();
                ClientMmap clientMmap = null;
                return clientMmap;
            }
            ++this.outstandingMmapCount;
            replica.mmapData = map;
            this.ref(replica);
            newCond.signalAll();
            ClientMmap clientMmap = new ClientMmap(replica, map, anchored);
            return clientMmap;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public void close() {
        try {
            Map.Entry<Long, ShortCircuitReplica> entry;
            this.lock.lock();
            if (this.closed) {
                return;
            }
            this.closed = true;
            LOG.info(this + ": closing");
            this.maxNonMmappedEvictableLifespanMs = 0L;
            this.maxEvictableMmapedSize = 0;
            IOUtils.cleanup(LOG, this.cacheCleaner);
            while ((entry = this.evictable.firstEntry()) != null) {
                this.purge(entry.getValue());
            }
            while ((entry = this.evictableMmapped.firstEntry()) != null) {
                this.purge(entry.getValue());
            }
        }
        finally {
            this.lock.unlock();
        }
        IOUtils.cleanup(LOG, this.shmManager);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    public void accept(CacheVisitor visitor) {
        this.lock.lock();
        try {
            HashMap<ExtendedBlockId, ShortCircuitReplica> replicas = new HashMap<ExtendedBlockId, ShortCircuitReplica>();
            HashMap<ExtendedBlockId, SecretManager.InvalidToken> failedLoads = new HashMap<ExtendedBlockId, SecretManager.InvalidToken>();
            for (Map.Entry<ExtendedBlockId, Waitable<ShortCircuitReplicaInfo>> entry : this.replicaInfoMap.entrySet()) {
                Waitable<ShortCircuitReplicaInfo> waitable = entry.getValue();
                if (!waitable.hasVal()) continue;
                if (waitable.getVal().getReplica() != null) {
                    replicas.put(entry.getKey(), waitable.getVal().getReplica());
                    continue;
                }
                failedLoads.put(entry.getKey(), waitable.getVal().getInvalidTokenException());
            }
            if (LOG.isDebugEnabled()) {
                StringBuilder builder = new StringBuilder();
                builder.append("visiting ").append(visitor.getClass().getName()).append("with outstandingMmapCount=").append(this.outstandingMmapCount).append(", replicas=");
                String prefix = "";
                for (Map.Entry entry : replicas.entrySet()) {
                    builder.append(prefix).append(entry.getValue());
                    prefix = ",";
                }
                prefix = "";
                builder.append(", failedLoads=");
                for (Map.Entry entry : failedLoads.entrySet()) {
                    builder.append(prefix).append(entry.getValue());
                    prefix = ",";
                }
                prefix = "";
                builder.append(", evictable=");
                for (Map.Entry<Object, Object> entry : this.evictable.entrySet()) {
                    builder.append(prefix).append(entry.getKey()).append(":").append(entry.getValue());
                    prefix = ",";
                }
                prefix = "";
                builder.append(", evictableMmapped=");
                for (Map.Entry<Object, Object> entry : this.evictableMmapped.entrySet()) {
                    builder.append(prefix).append(entry.getKey()).append(":").append(entry.getValue());
                    prefix = ",";
                }
                LOG.debug(builder.toString());
            }
            visitor.visit(this.outstandingMmapCount, replicas, failedLoads, this.evictable, this.evictableMmapped);
        }
        finally {
            this.lock.unlock();
        }
    }

    public String toString() {
        return "ShortCircuitCache(0x" + Integer.toHexString(System.identityHashCode(this)) + ")";
    }

    public ShortCircuitShm.Slot allocShmSlot(DatanodeInfo datanode, DomainPeer peer, MutableBoolean usedPeer, ExtendedBlockId blockId, String clientName) throws IOException {
        if (this.shmManager != null) {
            return this.shmManager.allocSlot(datanode, peer, usedPeer, blockId, clientName);
        }
        return null;
    }

    public void freeSlot(ShortCircuitShm.Slot slot) {
        Preconditions.checkState(this.shmManager != null);
        slot.makeInvalid();
        this.shmManager.freeSlot(slot);
    }

    public void scheduleSlotReleaser(ShortCircuitShm.Slot slot) {
        Preconditions.checkState(this.shmManager != null);
        this.releaserExecutor.execute(new SlotReleaser(slot));
    }

    @VisibleForTesting
    public DfsClientShmManager getDfsClientShmManager() {
        return this.shmManager;
    }

    @VisibleForTesting
    public static interface CacheVisitor {
        public void visit(int var1, Map<ExtendedBlockId, ShortCircuitReplica> var2, Map<ExtendedBlockId, SecretManager.InvalidToken> var3, Map<Long, ShortCircuitReplica> var4, Map<Long, ShortCircuitReplica> var5);
    }

    public static interface ShortCircuitReplicaCreator {
        public ShortCircuitReplicaInfo createShortCircuitReplicaInfo();
    }

    private class SlotReleaser
    implements Runnable {
        private final ShortCircuitShm.Slot slot;

        SlotReleaser(ShortCircuitShm.Slot slot) {
            this.slot = slot;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            DataOutputStream out;
            DomainSocket sock;
            block11: {
                if (LOG.isTraceEnabled()) {
                    LOG.trace(ShortCircuitCache.this + ": about to release " + this.slot);
                }
                DfsClientShm shm = (DfsClientShm)this.slot.getShm();
                DomainSocket shmSock = shm.getPeer().getDomainSocket();
                sock = null;
                out = null;
                String path = shmSock.getPath();
                boolean success = false;
                try {
                    sock = DomainSocket.connect(path);
                    out = new DataOutputStream(new BufferedOutputStream(sock.getOutputStream()));
                    new Sender(out).releaseShortCircuitFds(this.slot.getSlotId());
                    DataInputStream in = new DataInputStream(sock.getInputStream());
                    DataTransferProtos.ReleaseShortCircuitAccessResponseProto resp = DataTransferProtos.ReleaseShortCircuitAccessResponseProto.parseFrom(PBHelper.vintPrefixed(in));
                    if (resp.getStatus() != DataTransferProtos.Status.SUCCESS) {
                        String error = resp.hasError() ? resp.getError() : "(unknown)";
                        throw new IOException(resp.getStatus().toString() + ": " + error);
                    }
                    if (LOG.isTraceEnabled()) {
                        LOG.trace(ShortCircuitCache.this + ": released " + this.slot);
                    }
                    if (success = true) {
                        ShortCircuitCache.this.shmManager.freeSlot(this.slot);
                        break block11;
                    }
                    shm.getEndpointShmManager().shutdown(shm);
                }
                catch (IOException e) {
                    block12: {
                        try {
                            LOG.error(ShortCircuitCache.this + ": failed to release " + "short-circuit shared memory slot " + this.slot + " by sending " + "ReleaseShortCircuitAccessRequestProto to " + path + ".  Closing shared memory segment.", e);
                            if (success) {
                                ShortCircuitCache.this.shmManager.freeSlot(this.slot);
                                break block12;
                            }
                            shm.getEndpointShmManager().shutdown(shm);
                        }
                        catch (Throwable throwable) {
                            if (success) {
                                ShortCircuitCache.this.shmManager.freeSlot(this.slot);
                            } else {
                                shm.getEndpointShmManager().shutdown(shm);
                            }
                            IOUtils.cleanup(LOG, sock, out);
                            throw throwable;
                        }
                    }
                    IOUtils.cleanup(LOG, sock, out);
                }
            }
            IOUtils.cleanup(LOG, sock, out);
        }
    }

    private class CacheCleaner
    implements Runnable,
    Closeable {
        private ScheduledFuture<?> future;

        private CacheCleaner() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            ShortCircuitCache.this.lock.lock();
            try {
                long evictionTimeMs;
                Map.Entry entry;
                if (ShortCircuitCache.this.closed) {
                    return;
                }
                long curMs = Time.monotonicNow();
                if (LOG.isDebugEnabled()) {
                    LOG.debug(this + ": cache cleaner running at " + curMs);
                }
                int numDemoted = ShortCircuitCache.this.demoteOldEvictableMmaped(curMs);
                int numPurged = 0;
                Long evictionTimeNs = 0L;
                while ((entry = ShortCircuitCache.this.evictable.ceilingEntry(evictionTimeNs)) != null && (evictionTimeMs = TimeUnit.MILLISECONDS.convert(evictionTimeNs = entry.getKey(), TimeUnit.NANOSECONDS)) + ShortCircuitCache.this.maxNonMmappedEvictableLifespanMs < curMs) {
                    ShortCircuitReplica replica = (ShortCircuitReplica)entry.getValue();
                    if (LOG.isTraceEnabled()) {
                        LOG.trace("CacheCleaner: purging " + replica + ": " + StringUtils.getStackTrace(Thread.currentThread()));
                    }
                    ShortCircuitCache.this.purge(replica);
                    ++numPurged;
                }
                if (LOG.isDebugEnabled()) {
                    LOG.debug(this + ": finishing cache cleaner run started at " + curMs + ".  Demoted " + numDemoted + " mmapped replicas; " + "purged " + numPurged + " replicas.");
                }
            }
            finally {
                ShortCircuitCache.this.lock.unlock();
            }
        }

        @Override
        public void close() throws IOException {
            if (this.future != null) {
                this.future.cancel(false);
            }
        }

        public void setFuture(ScheduledFuture<?> future) {
            this.future = future;
        }

        public long getRateInMs() {
            long minLifespanMs = Math.min(ShortCircuitCache.this.maxNonMmappedEvictableLifespanMs, ShortCircuitCache.this.maxEvictableMmapedLifespanMs);
            long sampleTimeMs = minLifespanMs / 4L;
            return sampleTimeMs < 1L ? 1L : sampleTimeMs;
        }
    }
}

