/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.fs.s3presto.shaded.org.apache.hadoop.hdfs.server.namenode;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.flink.fs.s3presto.shaded.com.facebook.presto.hadoop.$internal.com.google.common.collect.ImmutableList;
import org.apache.flink.fs.s3presto.shaded.com.facebook.presto.hadoop.$internal.com.google.common.collect.Lists;
import org.apache.flink.fs.s3presto.shaded.com.facebook.presto.hadoop.$internal.com.google.common.collect.Maps;
import org.apache.flink.fs.s3presto.shaded.org.apache.hadoop.classification.InterfaceAudience;
import org.apache.flink.fs.s3presto.shaded.org.apache.hadoop.fs.XAttr;
import org.apache.flink.fs.s3presto.shaded.org.apache.hadoop.hdfs.protocol.QuotaExceededException;
import org.apache.flink.fs.s3presto.shaded.org.apache.hadoop.hdfs.server.namenode.INode;
import org.apache.flink.fs.s3presto.shaded.org.apache.hadoop.hdfs.server.namenode.INodeAttributes;
import org.apache.flink.fs.s3presto.shaded.org.apache.hadoop.hdfs.server.namenode.XAttrFeature;

@InterfaceAudience.Private
public class XAttrStorage {
    private static final Map<String, String> internedNames = Maps.newHashMap();

    public static List<XAttr> readINodeXAttrs(INode inode, int snapshotId) {
        XAttrFeature f = inode.getXAttrFeature(snapshotId);
        return f == null ? ImmutableList.of() : f.getXAttrs();
    }

    public static List<XAttr> readINodeXAttrs(INodeAttributes inodeAttr) {
        XAttrFeature f = inodeAttr.getXAttrFeature();
        return f == null ? ImmutableList.of() : f.getXAttrs();
    }

    public static void updateINodeXAttrs(INode inode, List<XAttr> xAttrs, int snapshotId) throws QuotaExceededException {
        if (xAttrs == null || xAttrs.isEmpty()) {
            if (inode.getXAttrFeature() != null) {
                inode.removeXAttrFeature(snapshotId);
            }
            return;
        }
        ArrayList<XAttr> internedXAttrs = Lists.newArrayListWithCapacity(xAttrs.size());
        for (XAttr xAttr : xAttrs) {
            String name = xAttr.getName();
            String internedName = internedNames.get(name);
            if (internedName == null) {
                internedName = name;
                internedNames.put(internedName, internedName);
            }
            XAttr internedXAttr = new XAttr.Builder().setName(internedName).setNameSpace(xAttr.getNameSpace()).setValue(xAttr.getValue()).build();
            internedXAttrs.add(internedXAttr);
        }
        ImmutableList<XAttr> newXAttrs = ImmutableList.copyOf(internedXAttrs);
        if (inode.getXAttrFeature() != null) {
            inode.removeXAttrFeature(snapshotId);
        }
        inode.addXAttrFeature(new XAttrFeature(newXAttrs), snapshotId);
    }
}

